<?php

namespace App\Http\Controllers\Api\Auth;

use App\Http\Controllers\Api\BaseController;
use App\Models\Main\User;
use Illuminate\Http\Request;
use Tymon\JWTAuth\Exceptions\JWTException;
use Tymon\JWTAuth\Facades\JWTAuth;

class AuthController extends BaseController
{
    protected $data = [];

    // User login
    public function login(Request $request)
    {
        $credentials = $request->only('username', 'password');

        try {
            if (! $token = JWTAuth::attempt($credentials)) {
                return $this->sendError(['error' => 'Invalid credentials'], 'Login Failed');
            }
            // Get the authenticated user.
            $user = auth('api')->user();
            $this->data = [
                'id'                => $user->id,
                'username'          => $user->username,
                'email'             => $user->email,
                'name'              => $user->name,
                'phone'             => $user->phone,
                'token'             => $token ,
            ];
            return $this->sendResponse($this->data, 'Login successful');
        } catch (JWTException $e) {
            return $this->sendError(['error' => 'Could not create token'], 'Login Failed');
        }
    }

    // Get authenticated user
    public function getUser()
    {
        try {
            if (! $user = JWTAuth::parseToken()->authenticate()) {
                return response()->json(['error' => 'User not found'], 404);
            }
        } catch (JWTException $e) {
            return response()->json(['error' => 'Invalid token'], 400);
        }

        return response()->json(compact('user'));
    }

    // User logout
    public function logout()
    {
        JWTAuth::invalidate(JWTAuth::getToken());

        return response()->json(['message' => 'Successfully logged out']);
    }
}
