<?php

namespace App\Http\Controllers\Api;

use App\Http\Controllers\Controller;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\App;

class BaseController extends Controller
{
public function __construct()
    {
        if(request()->header('lang') == 'ar' || request()->lang == 'ar'){
            App::setlocale('ar');

        }else{
            App::setlocale('en');
        }
    }
    public function sendResponse($result, $message = '' )
    {
    	$response = [
            'check' => true,
            'data'  => $result,
            'msg'   => $message,
        ];


        return response()->json($response, 200);
    }

    public function sendError($error, $errorMessages = [], $code = 200)
    {
    	$response = [
            'check' => false,
            'msg' => $error,
        ];

        if(!empty($errorMessages)){
            $response['data'] = $errorMessages;
        }

        return response()->json($response, $code);
    }
}

