<?php

namespace App\Http\Controllers\Api\Main;

use App\Http\Controllers\Api\BaseController;
use App\Http\Controllers\Controller;
use App\Http\Requests\Main\UserPermissonRequest;
use App\Http\Requests\Main\UserRequest;
use App\Repositories\Main\UserRepository;
use App\Http\Responses\Main\UserResponse;
use App\Models\Main\User;
use Faker\Provider\Base;
use Illuminate\Http\Request;

class UserController extends BaseController
{
    protected $repo;
    protected $data = [];

    public function __construct(UserRepository $repo)
    {
        $this->repo = $repo;
    }

    public function index(Request $request)
    {
        $filter = [
            'word'              => $request['word'] ?? null,
            'is_active'         => $request['is_active'] ?? 1,
            'page'              => $request['page'] ?? 1,
            'perPage'           => $request['rows'] ?? 10,
        ];
        $this->data['items'] = UserResponse::collection($this->repo->index($filter));
        return  $this->sendResponse($this->data);
    }

    public function store(UserRequest $request)
    {
        $this->data['item'] = new UserResponse($this->repo->create($request->validated()));

        return  $this->sendResponse($this->data , trans('main.add_success'));
    }

    public function show($id)
    {
        $this->data['item'] = new UserResponse($this->repo->show($id));
        return $this->sendResponse($this->data);
        
    }

    public function update(UserRequest $request,$id)
    {
        $item = User::findOrFail($id);
        $item->update($request->validated());
        $this->data['item'] = new UserResponse($item);
        return $this->sendResponse($this->data,trans('main.update_success'));
    }
    public function updatePermissions(UserPermissonRequest $request, $id)
    {
        $this->repo->update_permissions($id , $request->validated());
        return $this->sendResponse($this->data, trans('main.update_success'));
    }
    public function destroy( $id)
    {
        $item = User::findOrFail($id);
        $item->delete();
        return $this->sendResponse($this->data,trans('main.delete_success'));
    }
}
