<?php

namespace App\Http\Requests\Inventory;

use Illuminate\Foundation\Http\FormRequest;
use Illuminate\Validation\Rule;

class ItemRequest extends FormRequest
{
    public function authorize(): bool
    {
        return true;
    }

    public function rules(): array
    {
            $itemId = $this->route('item'); // assuming route like /items/{item}

        return [
            'name_ar'     => [
                'required',
                'string',
                'max:255',
                Rule::unique('items', 'name_ar')->ignore($itemId)
            ],
            'name_en'     => [
                'required',
                'string',
                'max:255',
                Rule::unique('items', 'name_en')->ignore($itemId)
            ],
            'caliber'       => 'required|integer|min:1',
            'is_broked'     => 'required|boolean',
            'is_set'        => 'required|boolean',
        ];
    }
}
