<?php

namespace App\Http\Responses\Inventory;

use Illuminate\Http\Resources\Json\JsonResource;

class ItemResponse extends JsonResource
{
    public function toArray($request)
        {   
            $lang = request()->header('lang') ?? 'en'; // fallback to query/body or 'en'
            return [
            'id'                        => $this->sub_category_id,
            'name_ar'                   => $this->name_ar,
            'name_en'                   => $this->name_en,
            'name'                      => $this->{'name_' . $lang},
            'code'                      => $this->code,
            'cost_identity_m_id'        => $this->cost_identity_m_id,
            'caliber'                   => $this->categorys,
            'is_broked'                 => $this->is_used,
            'des'                       => $this->des,
            'is_barcode'                => $this->is_barcode,
            'is_set'                    => $this->is_package,
            'package_ids'               => $this->package_ids,
            'average_purchase_cost'     => $this->average_purchase_cost,
            'purchases_revenue_id'      => $this->purchases_revenue_id,
            'purchases_return_id'       => $this->purchases_return_id,
            'purchases_discount_id'     => $this->purchases_discount_id,
            'sales_revenue_id'          => $this->sales_revenue_id,
            'sales_return_id'           => $this->sales_return_id,
            'sales_discount_id'         => $this->sales_discount_id,
            'tax_id'                    => $this->tax_id,
            'default_size'              => $this->default_size,

            ];
        }

    /**
     * Custom response for collections and paginated collections.
     */
    public static function collection($resource)
    {
        // If it's paginated, use Laravel's pagination response format
        if ($resource instanceof \Illuminate\Contracts\Pagination\LengthAwarePaginator) {
            return[
                    'items' => parent::collection($resource),
                
                    'current_page' => $resource->currentPage(),
                    'last_page'    => $resource->lastPage(),
                    'per_page'     => $resource->perPage(),
                    'total'        => $resource->total(),
                    'first_page_url' => $resource->url(1),
                    'from' => $resource->firstItem(),
                    'last_page_url' => $resource->url($resource->lastPage()),
                    'links' => [],
                    'next_page_url' => $resource->nextPageUrl(),
                    'path' => $resource->path(),
                    'prev_page_url' => $resource->previousPageUrl(),
                    'to' => $resource->lastItem()
                
                ];
        }

        // If not paginated, just return the collection of resources
        return [
             parent::collection($resource),
        ];
    }
}
