<?php

namespace App\Models\Main;

// use Illuminate\Contracts\Auth\MustVerifyEmail;

use App\Models\Sales\Shift;
use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Foundation\Auth\User as Authenticatable;
use Illuminate\Notifications\Notifiable;

class User extends Authenticatable implements \Tymon\JWTAuth\Contracts\JWTSubject
{
    use HasFactory, Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array<int, string>
     */
    protected $fillable = [
        'name',
        'email',
        'password',
        'branch_id',
        'role_id',
        'finance_year_id',
        'is_active'
    ];

    /**
     * The attributes that should be hidden for serialization.
     *
     * @var array<int, string>
     */
    protected $hidden = [
        'password',
        'remember_token',
    ];

    /**
     * Get the attributes that should be cast.
     *
     * @return array<string, string>
     */
    protected function casts(): array
    {
        return [
            'email_verified_at' => 'datetime',
            'password' => 'hashed',
        ];
    }
    public function branch(){
        return $this->belongsTo(Branch::class);
    }
    public function financeYear(){
        return $this->belongsTo(FinanceYear::class);
    }
    public function shift()
    {
        return $this->hasMany(Shift::class);
    }
    public function role(){
        return $this->belongsTo(Role::class);
    }
    public function permissions()
    {
        return $this->hasMany(\App\Models\Main\UserPermission::class, 'user_id');
    }
    public function getJWTIdentifier()
    {
        return $this->getKey();
    }

    public function getJWTCustomClaims()
    {
        return [];
    }
}
