<?php

namespace App\Repositories\Inventory;

use App\Models\Inventory\Item;
use Illuminate\Support\Facades\DB;

class ItemRepository
{
    /**
     * Get paginated list of Branch
     *
     * @param int $rows
     * @return array
     */
    public function index(array $params = [])
    {
        $query = DB::table('mab_sub_categorys');

        // Apply search filter if $search parameter is provided
        if ($params['word']) {
            $query->where(function ($q) use ($params) {
                $q->where('name_ar', 'LIKE', "%{$params['word']}%")
                ->orWhere('name_en', 'LIKE', "%{$params['word']}%");

            });
        }
        if(isset($params['is_active'])) {
            $query->where('active', $params['is_active']);
        }

        if(isset($params['perPage']) && $params['perPage'] > 0) {
            $categories = $query->paginate($params['perPage'], ['*'], 'page', $params['page'] ?? 1);
        } else {
            $categories = $query->get();
        }

        return $categories;
    }

    /**
     * Show single Item by ID
     *
     * @param int $id
     * @return Item|null
     */
    public function show(int $id): ?Item
    {
        return DB::table('mab_sub_categorys')->where('sub_category_id', $id)->first();
    }

    /**
     * Create new Item
     *
     * @param array $data
     * @return Item
     */
    public function create(array $data)
    {
        $insert = [
            'code'                      => $data['code'] ?? null,
            'name_en'                   => $data['name_en'] ?? null,
            'cost_identity_m_id'        => $data['cost_identity_m_id'] ?? null,
            'name_ar'                   => $data['name_ar'] ?? null,
            'categorys'                 => $data['caliber'] ?? null,
            'is_used'                   => $data['is_broked'] ?? 0,
            'des'                       => $data['des'] ?? null,
            'is_barcode'                => $data['is_barcode'] ?? 0,
            'is_package'                => $data['is_set'] ?? 0,
            'package_ids'               => $data['package_ids'] ?? null,
            'average_purchase_cost'     => $data['average_purchase_cost'] ?? 0,
            'purchases_revenue_id'      => $data['purchases_revenue_id'] ?? null,
            'purchases_return_id'       => $data['purchases_return_id'] ?? null,
            'purchases_discount_id'     => $data['purchases_discount_id'] ?? null,
            'sales_revenue_id'          => $data['sales_revenue_id'] ?? null,
            'sales_return_id'           => $data['sales_return_id'] ?? null,
            'sales_discount_id'         => $data['sales_discount_id'] ?? null,
            'tax_id'                    => $data['tax_id'] ?? null,
            'default_size'              => $data['default_size'] ?? null,
            ];
        $insert['add_user']     = auth('api')->user()->id ?? 1;
        $insert['categorys']    = (is_array($insert['categorys'] ?? '')) ? implode(',', $insert['categorys']) : $insert['categorys'];
        $insert['package_ids']  = implode(',', $insert['package_ids'] ?? []);
        DB::beginTransaction();
        try {
            $Item = DB::table('mab_sub_categorys')->insertGetId($insert);
            DB::commit();
        } catch (\Exception $e) {
            DB::rollBack();
            throw $e;
        }
        return DB::table('mab_sub_categorys')->where('sub_category_id', $Item)->first();
    }

    /**
     * Update existing Item by ID
     *
     * @param int $id
     * @param array $data
     * @return Item|null
     */
    public function update(int $id, array $data): ?Item
    {
        $Item = Item::where('id', $id)
            ->first();

        if (!$Item) {
            return null;
        }

        $Item->update($data);

        return $Item;
    }

    /**
     * Soft delete Item by ID
     *
     * @param int $id
     * @return bool
     */
    public function delete(int $id): bool
    {
        $Item = Item::where('id', $id)->first();

        if (!$Item) {
            return false;
        }

        $Item->update(['is_active' => true]);

        return true;
    }
}
