<?php

namespace App\Services;

class CrudStubGenerator
{
    public function getModelContent($name, $folder)
    {
        return "<?php

        namespace App\Models\\$folder;

        use Illuminate\Database\Eloquent\Model;

        class $name extends Model
        {
            protected \$guarded = [];
        }
        ";
    }

    public function getControllerContent($name, $folder)
    {
        return "<?php

        namespace App\Http\Controllers\Api\\$folder;

        use App\Http\Controllers\Api\BaseController;
        use App\Repositories\\$folder\\{$name}Repository;
        use App\Http\Requests\\$folder\\{$name}Request;
        use App\Http\Responses\\$folder\\{$name}Response;
        use App\Models\\$folder\\$name;
        use Illuminate\Http\Request;

        class {$name}Controller extends BaseController
        {
            protected \$repo;
            protected \$data = [];

            public function __construct({$name}Repository \$repo)
            {
                \$this->repo = \$repo;

            }

            public function index(Request \$request)
            {
                \$filter = [
                    'word'      => \$request['word'] ?? null,
                    'page'      => \$request['page'] ?? 1,
                    'perPage'   => \$request['rows'] ?? 10,
                ];
                \$this->data['items'] = {$name}Response::collection(\$this->repo->index(\$filter));
                return \$this->sendResponse(\$this->data);
            }

            public function store({$name}Request \$request)
            {
                \$this->data['item'] = new {$name}Response(\$this->repo->create(\$request->validated()));
                return \$this->sendResponse(\$this->data, trans('main.create_successfully'));
            }

            public function show(\$id)
            {
                \$this->data['item'] = new {$name}Response(\$this->repo->show(\$id));
                return \$this->sendResponse(\$this->data);
            }

            public function update({$name}Request \$request, {$name} \$item)
            {
                \$item->update(\$request->validated());
                \$this->data['item'] = new {$name}Response(\$item);
                return \$this->sendResponse(\$this->data, trans('main.update_successfully'));

            }

            public function destroy({$name} \$item)
            {
                \$item->delete();
                return \$this->sendResponse(\$this->data, trans('main.delete_success'));

            }
        }
        ";
    }

    public function getRequestContent($name, $folder)
    {
        return "<?php

        namespace App\Http\Requests\\$folder;

        use Illuminate\Foundation\Http\FormRequest;

        class {$name}Request extends FormRequest
        {
            public function authorize(): bool
            {
                return true;
            }

            public function rules(): array
            {
                return [
                    // Define validation rules here
                ];
            }
        }
        ";
    }

    public function getResponseContent($name, $folder)
    {
        return "<?php

        namespace App\Http\Responses\\$folder;

        use Illuminate\Http\Resources\Json\JsonResource;

        class {$name}Response extends JsonResource
        {
            public function toArray(\$request): array
            {
                return parent::toArray(\$request);
            }
        }
        ";
    }

    public function getRepositoryContent($name, $folder)
    {
        return "<?php

        namespace App\Repositories\\$folder;

        use App\Models\\$folder\\$name;

        class {$name}Repository
        {
            public function index(array \$params = [])
            {
                \$query = {$name}::query();

                if (!empty(\$params['word'])) {
                    \$query->where(function (\$q) use (\$params) {
                        \$q->where('name_ar', 'like', \"%{\$params['word']}%\")
                        ->orWhere('name_en', 'like', \"%{\$params['word']}%\");
                    });
                }

                if (isset(\$params['is_active'])) {
                    \$query->where('is_active', \$params['is_active']);
                }

                return isset(\$params['perPage']) && \$params['perPage'] > 0
                    ? \$query->paginate(\$params['perPage'], ['*'], 'page', \$params['page'] ?? 1)
                    : \$query->get();
            }

            public function show(int \$id): ?{$name}
            {
                return {$name}::where('id', \$id)->first();
            }

            public function create(array \$data): {$name}
            {
                return {$name}::create(\$data);
            }

            public function update(int \$id, array \$data): ?{$name}
            {
                \$item = {$name}::where('id', \$id)->first();
                if (!\$item) {
                    return null;
                }
                \$item->update(\$data);
                return \$item;
            }

            public function delete(int \$id): bool
            {
                \$item = {$name}::where('id', \$id)->first();
                if (!\$item) {
                    return false;
                }
                \$item->update(['is_active' => false]);
                return true;
            }
        }
        ";
    }
}
