<?php

namespace App\Services;

use Illuminate\Support\Facades\DB;

class UpdateItemStock
{
    public function updateItemStock($item_id, $quantity , $type ) // type 1 => inc , 2=> dec 
    {
        // check if item is exist before 
        $old_quantity = DB::table('item_stocks')->where('item_id' , $item_id)->value('quantity') ?? 0;

        if($old_quantity > 0){
            // Determine new quantity based on type
            if ($type == 1) {
                $newQuantity = $old_quantity + $quantity;
            } elseif ($type == 2) {
                $newQuantity = $old_quantity - $quantity;
            } else {
                // Invalid type, you may want to handle this case
                return false;
            }
            DB::table('item_stocks')->where('item_id' , $item_id)->update(['quantity' => $newQuantity ]);
        }elseif($old_quantity == 0){
            if ($type == 1) {
                $newQuantity = $old_quantity + $quantity;
            } elseif ($type == 2) {
                $newQuantity = $old_quantity - $quantity;
            } else {
                // Invalid type, you may want to handle this case
                return false;
            }
            DB::table('item_stocks')->where('item_id' , $item_id)->insert([
                'quantity' => $newQuantity , 
                'item_id'   => $item_id ,
            ]);

        }
    }

}
