<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Str;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('client_access_tokens', function (Blueprint $table) {
            $table->id();
            $table->string('client_id')->unique();
            $table->longText('token')->unique();
            $table->timestamps();
        });
        DB::table('client_access_tokens')->insert([
            'client_id'     => '1044',
            'token'         => Str::random(200),
            'created_at'    => now(),
            'updated_at'    => now(),
        ]);
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('client_access_tokens');
    }
};
