<?php

namespace App\Classes\Assets;

use App\Classes\Finance\DailyJournalHelper;
use App\Models\Assets\Assets;
use App\Models\Finance\AccountTree;
use App\Models\Finance\DailyJournal;
use App\Models\Finance\Treasury;
use App\Models\Main\Bank;
use App\Models\Main\Setting;
use App\Models\Purchases\PurchasesVendor;
use Illuminate\Support\Facades\DB;

class AssetsHelper
{
    function get_next_codes( $year, $branch)
    {
        $data['year_ser'] = intval(DB::table('assets_m')
                ->where('finance_year_id', $year)
                ->max('year_ser')) + 1;

        $data['month_ser'] = intval(DB::table('assets_m')
                ->where('finance_year_id', $year)
                ->max('month_ser')) + 1;

        $data['branch_ser'] = intval(DB::table('assets_m')
                ->where('branch_id', $branch)
                ->max('branch_ser')) + 1;

        return $data;
    }
    function generate_code( $category_id)
    {
        $code = intval(DB::table('assets_m')
                ->where('asset_category_id', $category_id)
                ->max('asset_m_id')) + 1;
        $category_id = str_pad($category_id, 2, '0', STR_PAD_LEFT);
        $code = str_pad($code, 4, '0', STR_PAD_LEFT);
        $data = $category_id . '-' . $code;
        return $data;
    }
    function generate_journal($id)
    {
        $main       = Assets::get_assets_m( $id ,'en' );
        $details    = Assets::get_assets_payments( $id ,'en' );
        if(!isset($main->active) || $main->active == 0 ){
            DailyJournal::delete_daily_journal_m($main->daily_journal_m_id);
            return array( true ,  '' ) ;
        }


            $items      = [];
            $journal_data  = array(
                'finance_year_id'   => $main->finance_year_id  ,
                'branch_id'         => $main->branch_id ,
                'des'               => $main->description ,
                'journal_date'      => $main->purchase_date ,
                'document_id'       => $id ,
                'daily_type_id'     => 21 ,
                'auto_generated'    => 1 ,
                'journal_active'    => 1 ,
                'confirmed'         => 1
            );
            if($main->daily_journal_m_id > 0 ){
                $journal_data['daily_journal_id'] = $main->daily_journal_m_id;
            }

            $tax_id     = Setting::get_main_setting_by_code('default_purchases_vat')->value ?? false ;
            $tax        = DB::table('taxes')->where('tax_id' , $tax_id)->first();

             $items[]   = array(
                'account_tree_id'   => $main->asset_acc_id ,
                'cost_center_id'    => $main->cost_center_id ?? 0 ,
                'debit'             => 0   ,
                'credit'            => $main->total_value_without_vat ,
                'description'       => $main->description
            );
            $items[]   = array(
                'account_tree_id'   => $tax->account_tree_id ,
                'cost_center_id'    => 0 ,
                'debit'             => 0   ,
                'credit'            => $main->total_vat ,
                'description'       => $main->description
            );

            foreach ( $details as $key => $detail ) {
                $account_tree_id = 0;
                switch ($detail->payment_method) {
                    case '1': // bank
                        $account_tree_id = Bank::get_bank($detail->payment_method_id , 'en')->account_tree_id ?? 0;
                    break;
                    case '3': //treasury
                        $account_tree_id = Treasury::get_treasury($detail->payment_method_id, 'en')->account_tree_id ?? 0;
                    break;

                    case '2'://account
                        $account_tree_id = AccountTree::get_account_tree($detail->payment_method_id, 'en')->id ?? 0;
                    break;
                    case '4'://supplier
                        $account_tree_id = PurchasesVendor::get_purchases_vendor($detail->payment_method_id, 'en')->account_tree_id ?? 0;
                    break;
                    default:
                        $account_tree_id = 0;
                    break;
                }
                $items[]    = array(
                    'account_tree_id'   => $account_tree_id ,
                    'cost_center_id'    => 0 ,
                    'debit'             => $detail->value_without_vat  ,
                    'credit'            => 0,
                    'description'       => $main->description
                );

                if($detail->vat > 0 ){
                    $detail_tax = DB::table('taxes')->where('tax_id' , $detail->tax_id)->first();

                    $items[]    = array(
                        'account_tree_id'   => $detail_tax->account_tree_id ?? 0 ,
                        'cost_center_id'    => 0 ,
                        'debit'             => $detail->vat  ,
                        'credit'            => 0,
                        'description'       => $main->description
                    );
                }

            }

            $journal =  (new DailyJournalHelper)->generate_journal($journal_data , $items);
            if($journal[0]){

                DB::table('assets_m')
                    ->where('asset_m_id' , $id)
                    ->update( ['daily_journal_m_id' => $journal[2]] );
                return $journal;

            }else{

                $response = [
                   'check' => false,
                   'data'  => $journal ,
                   'msg'   => $journal[1]
                ];
                header('Content-Type: application/json; charset=utf-8; ');
                header('Access-Control-Allow-Origin:*');
                header('Access-Control-Allow-Headers:*');
                echo json_encode($response);
                die();

            }
    }
    function check_status($id , $finance_year = null){
        $main       = Assets::get_assets_m( $id ,'en' );
        // if($main->depr_value > 0  || $main->finance_year_id != $finance_year ){
        //     return false;
        // }else{
            return true;
        // }
    }
}
