<?php

namespace App\Classes\Finance;
use Illuminate\Support\Facades\DB;
use App\Models\Finance\MultiVoucher;
use App\Models\Finance\DailyJournal;
use App\Models\Main\Setting;


use App\Models\Sales\Customer;
use App\Models\Purchases\PurchasesVendor;
use App\Models\Main\Bank;
use App\Models\Finance\Tax;
use App\Models\Finance\Treasury;


class MultiVoucherHelper
{
    function get_next_codes($date, $year, $branch)
    {
        $data['year_ser'] = intval(DB::table('multi_voucher_m')
                ->where('finance_year_id', $year)
                ->max('year_ser')) + 1;

        $data['month_ser'] = intval(DB::table('multi_voucher_m')
                ->where('finance_year_id', $year)
                ->max('month_ser')) + 1;

        $data['branch_ser'] = intval(DB::table('multi_voucher_m')
                ->where('branch_id', $branch)
                ->max('branch_ser')) + 1;

        return $data;
    }

    function can_edit_or_delete($id)
    {
        return true;
    }

    function generate_journal($id)
    {
        $check          = Setting::get_main_setting_by_code('multi_voucher_journal')->value ?? false ;
        if(!$check){
            return array( true ,  '' ) ;
        }

        $master         = MultiVoucher::get_multi_voucher_m($id , 'en');
        $details        = MultiVoucher::get_multi_voucher_d($id , 'en');
        $files          = MultiVoucher::get_attachs($id);
        $items          = [];


        if(!isset($master->active) || $master->active == 0 ){
            DailyJournal::delete_daily_journal_m($master->daily_journal_m_id);
            return array( true ,  '' ) ;
        }



        $journal_data   = array(
            'finance_year_id'   => $master->finance_year_id  ,
            'branch_id'         => $master->branch_id ,
            'des'               => $master->description  ,
            'journal_date'      => $master->action_date ,
            'document_id'       => $id ,
            'daily_type_id'     => 20 ,
            'auto_generated'    => 1 ,
            'journal_active'    => 1 ,
            'confirmed'         => 1 ,
            'daily_journal_id'  => $master->daily_journal_m_id
        );

        foreach ($details as $key => $row) {

             switch ($row->dis_type) {
                case '1':
                    $account_tree_id = Treasury::get_treasury($row->dis_treasury_id, 'en')->account_tree_id ?? 0;
                break;
                case '2':
                    $account_tree_id = Bank::get_bank($row->dis_bank_id , 'en')->account_tree_id ?? 0;
                break;

                case '3':
                    $account_tree_id = Customer::get_customer($row->dis_customer_id, 'en')->account_tree_id ?? 0;
                break;
                case '4':
                    $account_tree_id = PurchasesVendor::get_purchases_vendor($row->dis_supplier_id, 'en')->account_tree_id ?? 0;
                break;
                case '5':
                    $account_tree_id = $row->dis_account_tree_id;
                break;

                default:
                    $account_tree_id = 0;
                break;
            }

            $items[]    = array(
                'account_tree_id'   => $account_tree_id ,
                'cost_center_id'    => $row->cost_centers ,
                'debit'             => ($row->voucher_type == 1 ? $row->amount_without_vat : 0 ) ,
                'credit'            => ($row->voucher_type == 2 ? $row->amount_without_vat : 0 ) ,
                'description'       => $row->description
            );

            if($row->tax_id > 0 ){
                $tax = Tax::get_tax($row->tax_id , 'en');
                $items[]    = array(
                    'account_tree_id'   => $tax->account_tree_id ,
                    'cost_center_id'    => $row->cost_centers ,
                    'debit'             => ($row->voucher_type == 1 ? $row->total_vat : 0 ) ,
                    'credit'            => ($row->voucher_type == 2 ? $row->total_vat : 0 ) ,
                    'description'       => $row->description
                );
            }

        }

        $journal = (new DailyJournalHelper)->generate_journal($journal_data , $items , $files);

        if($journal[0]){
            
            DB::table('multi_voucher_m')
                ->where('multi_voucher_m_id' , $id)
                ->update( ['daily_journal_m_id' => $journal[2]] );
            return $journal;

        }else{

            $response = [
               'check' => false,
               'data'  => $journal ,
               'msg'   => $journal[1]
            ];
            header('Content-Type: application/json; charset=utf-8; ');
            header('Access-Control-Allow-Origin:*');
            header('Access-Control-Allow-Headers:*');
            echo json_encode($response);
            die();

        }
        

    }


}
