<?php

namespace App\Classes\Finance;
use DB;
use App\Classes\Finance\DailyJournalHelper;
use App\Models\Finance\PaymentVoucher;
use App\Models\Sales\Customer;
use App\Models\Purchases\PurchasesVendor;
use App\Models\Main\Bank;
use App\Models\Finance\Treasury;
use App\Models\Main\Setting;
use App\Models\Finance\DailyJournal;



class PaymentVoucherHelper
 {

	function can_edit_or_delete($id)
	{
		
	    // $account 	= DB::table('voucher_receipts')->where('voucher_receipt_id' , $id )->first();
        

		return true;
	}

	function get_next_codes($date , $year , $branch){

		$data['year_ser'] = intval( DB::table('payment_vouchers')
	        ->where('finance_year_id' , $year)
	        ->max('year_ser') ) + 1 ;

	    $data['month_ser'] = intval( DB::table('payment_vouchers')
	        ->where('finance_year_id' , $year)
	        ->where('action_date' , 'like' , date("Y-m" , strtotime($date))."%" )
	        ->max('month_ser') ) + 1 ;

	    $data['branch_ser'] = intval( DB::table('payment_vouchers')
	        ->where('branch_id' , $branch)
	        ->max('branch_ser') ) + 1 ;

	    return $data;
	}
	

	function generate_journal($id){


        $check = Setting::get_main_setting_by_code('payment_voucher_journal')->value ?? false ;
        if(!$check){
            return array( true ,  '' ) ;
        }

        $main       = PaymentVoucher::get_payment_voucher($id , 'en');
        $files 		= PaymentVoucher::get_attachs($id);

        if(!isset($main->active) || $main->active == 0 ){
            DailyJournal::delete_daily_journal_m($main->daily_journal_id);
            return array( true ,  '' ) ;
        }

        switch ($main->to_type) {
        	case '1':
        		$to_account = $main->to_account_tree_id;
    		break;
    		case '2':
        		$to_account = PurchasesVendor::get_purchases_vendor($main->purchases_vendor_id, 'en')->account_tree_id ?? 0;
    		break;
        	case '3':
        		$to_account = Customer::get_customer($main->to_customer_id, 'en')->account_tree_id ?? 0;
    		break;
    		

        	default:
        		$to_account = 0;
    		break;
        }


        switch ($main->from_type) {
        	case '1':
        		$from_account = $main->from_account_tree_id;
    		break;
    		case '2':
        		$from_account = Treasury::get_treasury($main->from_treasury_id, 'en')->account_tree_id ?? 0;
    		break;
        	case '3':
        		$from_account = Bank::get_bank($main->from_bank_id , 'en')->account_tree_id ?? 0;
    		break;
    		case '4':
        		$from_account = Setting::get_main_setting_by_code('collection_Cheque')->value ;
    		break;

        	default:
        		$from_account = 0;
    		break;
        }


        $items 		= [];
        $journal_data  = array(
            'finance_year_id'   => $main->finance_year_id  ,
            'branch_id'         => $main->branch_id ,
            'des'           	=> $main->description  ,
            'journal_date'      => $main->action_date ,
            'document_id'       => $id ,
            'daily_type_id'     => 19 ,
            'auto_generated'    => 1 ,
            'journal_active'    => 1 ,
            'confirmed'         => 1 
        );

        if($main->daily_journal_id > 0 ){
            $journal_data['daily_journal_id'] = $main->daily_journal_id;
        }



        $items[]   	= array(
            'account_tree_id'	=> $from_account ,
            'cost_center_id'	=> 0 ,
            'debit'				=> 0  ,
            'credit'			=> $main->amount  ,
            'description'		=> $main->description 
        );

        $items[]    = array(
            'account_tree_id'		=> $to_account,
            'cost_center_id'		=> 0 ,
            'debit'					=> $main->amount ,
            'credit'				=> 0 ,
            'description'			=> $main->description 
        );

        $journal = (new DailyJournalHelper)->generate_journal($journal_data , $items , $files);

        if($journal[0]){
            
            DB::table('payment_vouchers')
                ->where('payment_voucher_id' , $id)
                ->update( ['daily_journal_id' => $journal[2]] );
            return $journal;

        }else{

            $response = [
               'check' => false,
               'data'  => $journal ,
               'msg'   => $journal[1]
            ];
            header('Content-Type: application/json; charset=utf-8; ');
            header('Access-Control-Allow-Origin:*');
            header('Access-Control-Allow-Headers:*');
            echo json_encode($response);
            die();

        }

    }


}