<?php

namespace App\Classes\Purchases;

use DB;

class PurchaseVendorStatmentReportHelper
{
    public static function get_account_purchase_vendor_statment($id, $lang, $params)
    {

        $purchase_query = DB::table('purchases_invoice_m')
            ->leftJoin('purchases_vendors','purchases_invoice_m.purchases_vendor_id','purchases_vendors.purchases_vendor_id')
            ->where('purchases_invoice_m.purchases_vendor_id',$id)
            ->where('purchases_invoice_m.purchases_invoice_active', 1)
            // ->groupBy('purchases_vendors.purchases_vendor_id')
            ->selectRaw('
                    purchases_invoice_m.purchases_invoice_m_id as id,
                    purchases_vendors.purchases_vendor_id      as vendor_id,
                    purchases_invoice_m.purchases_invoice_description as description ,
                    purchases_invoice_m.purchases_invoice_date as action_date,
                    purchases_invoice_m.total_with_vat as amount,
                    purchases_vendors.name_'.$lang.' as vendor_name,
                    "6" as type ,
                    "1" as sumtion
            ');

            if(isset($params['before'])){
                $purchase_query->where('purchases_invoice_m.purchases_invoice_date' , '<' , $params['before'] );
            }elseif(isset($params['from']) && isset($params['to'])){
                $purchase_query->where('purchases_invoice_m.purchases_invoice_date' , '>=' , $params['from']);
                $purchase_query->where('purchases_invoice_m.purchases_invoice_date' , '<=' , $params['to'] );
            }

            $vendor_status1          = $purchase_query->get()->toArray();
            $purchase_invoice_amount = collect($vendor_status1)->sum('amount');

        //=========================================================================


        $purchase_cash_query = DB::table('purchases_invoice_m')
            ->leftJoin('purchases_vendors','purchases_invoice_m.purchases_vendor_id','purchases_vendors.purchases_vendor_id')
            ->where('purchases_invoice_m.purchases_vendor_id',$id)
            ->where('purchases_invoice_m.purchases_invoice_active', 1)
            ->where('purchases_invoice_m.purchases_invoice_type_id',2)
            ->where('purchases_invoice_m.purchases_invoice_active',1)
            // ->groupBy('purchases_vendors.purchases_vendor_id')
            ->selectRaw('
                    purchases_invoice_m.purchases_invoice_m_id as id,
                    purchases_vendors.purchases_vendor_id      as vendor_id,
                    purchases_invoice_m.purchases_invoice_description as description ,
                    purchases_invoice_m.purchases_invoice_date as action_date,
                    purchases_invoice_m.total_with_vat as amount,
                    purchases_vendors.name_'.$lang.'           as vendor_name,
                    "6" as type ,
                    "0" as sumtion
            ');

            if(isset($params['before'])){
                $purchase_cash_query->where('purchases_invoice_m.purchases_invoice_date' , '<' , $params['before'] );
            }elseif(isset($params['from']) && isset($params['to'])){
                $purchase_cash_query->where('purchases_invoice_m.purchases_invoice_date' , '>=' , $params['from']);
                $purchase_cash_query->where('purchases_invoice_m.purchases_invoice_date' , '<=' , $params['to'] );
            }

            $vendor_status3          = $purchase_cash_query->get()->toArray();
            $purchase_cash_invoice_amount = collect($vendor_status3)->sum('amount');

        //=========================================================================


        $receipt_query = DB::table('receipt_vouchers')
            ->leftJoin('purchases_vendors','receipt_vouchers.purchases_vendor_id','purchases_vendors.purchases_vendor_id')
            ->where('receipt_vouchers.purchases_vendor_id',$id)
            ->where('receipt_vouchers.receipt_voucher_active',1)

            // ->groupBy('purchases_vendors.purchases_vendor_id')
            ->selectRaw('
                    receipt_vouchers.receipt_voucher_id   as id,
                    purchases_vendors.purchases_vendor_id as vendor_id,
                    receipt_vouchers.description          as description ,
                    receipt_vouchers.action_date          as action_date,
                    receipt_vouchers.amount  as amount,
                    purchases_vendors.name_'.$lang.'      as vendor_name,
                    "2" as type ,
                    "1" as sumtion
            ');

            if(isset($params['before'])){
                $receipt_query->where('receipt_vouchers.action_date' , '<' , $params['before'] );
            }elseif(isset($params['from']) && isset($params['to'])){
                $receipt_query->where('receipt_vouchers.action_date' , '>=' , $params['from'] );
                $receipt_query->where('receipt_vouchers.action_date' , '<=' , $params['to'] );
            }

            $vendor_status2          = $receipt_query->get()->toArray();
            $receipt_vouchers_amount = collect($vendor_status2)->sum('amount');

        //=========================================================================

        $payment_query = DB::table('payment_vouchers')
            ->leftJoin('purchases_vendors','payment_vouchers.purchases_vendor_id','purchases_vendors.purchases_vendor_id')
            ->where('payment_vouchers.purchases_vendor_id',$id)
            ->where('payment_vouchers.payment_voucher_active',1)



            // ->groupBy('purchases_vendors.purchases_vendor_id')
            ->selectRaw('
                    payment_vouchers.payment_voucher_id   as id,
                    purchases_vendors.purchases_vendor_id as vendor_id,
                    payment_vouchers.description          as description ,
                    payment_vouchers.action_date          as action_date,
                    payment_vouchers.amount   as amount,
                    purchases_vendors.name_'.$lang.'      as vendor_name,
                    "4" as type ,
                    "0" as sumtion
            ');

            if(isset($params['before'])){
                $payment_query->where('payment_vouchers.action_date' , '<' , $params['before'] );
            }elseif(isset($params['from']) && isset($params['to'])){
                $payment_query->where('payment_vouchers.action_date' , '>=' , $params['from'] );
                $payment_query->where('payment_vouchers.action_date' , '<=' , $params['to'] );
            }

            $vendor_status4          = $payment_query->get()->toArray();
            $payment_vouchers_amount = collect($vendor_status4)->sum('amount');

         //=========================================================================
         $multi_voucher_d_query = DB::table('multi_voucher_d')
         ->leftJoin('multi_voucher_m','multi_voucher_d.multi_voucher_m_id','multi_voucher_m.multi_voucher_m_id')
         ->leftJoin('purchases_vendors','multi_voucher_d.dis_supplier_id','purchases_vendors.purchases_vendor_id')
         ->where('multi_voucher_d.dis_supplier_id',$id)
         ->where('multi_voucher_active' , 1 )
         ->where('multi_voucher_d_active',1)
         ->where('multi_voucher_d.voucher_type',1) // debit

         // ->groupBy('purchases_vendors.purchases_vendor_id')
         ->selectRaw('
                multi_voucher_d.multi_voucher_d_id   as id,
                purchases_vendors.purchases_vendor_id as vendor_id,
                multi_voucher_d.description ,
                multi_voucher_m.action_date ,
                multi_voucher_d.amount ,
                purchases_vendors.name_'.$lang.' as vendor_name,
                "7" as type ,
                "2" as sumtion
         ');

         if(isset($params['before'])){
             $multi_voucher_d_query->where('multi_voucher_m.action_date' , '<' , $params['before'] );
         }elseif(isset($params['from']) && isset($params['to'])){
             $multi_voucher_d_query->where('multi_voucher_m.action_date' , '>=' , $params['from'] );
             $multi_voucher_d_query->where('multi_voucher_m.action_date' , '<=' , $params['to'] );
         }

         $vendor_status5          = $multi_voucher_d_query->get()->toArray();
         $multi_vouchers_d_amount = collect($vendor_status5)->sum('amount');

     //=========================================================================
     $multi_voucher_c_query = DB::table('multi_voucher_d')
     ->leftJoin('multi_voucher_m','multi_voucher_d.multi_voucher_m_id','multi_voucher_m.multi_voucher_m_id')
     ->leftJoin('purchases_vendors','multi_voucher_d.dis_supplier_id','purchases_vendors.purchases_vendor_id')
     ->where('multi_voucher_d.dis_supplier_id',$id)
     ->where('multi_voucher_active' , 1 )
     ->where('multi_voucher_d_active',1)
     ->where('multi_voucher_d.voucher_type',2) // credit
     // ->groupBy('purchases_vendors.purchases_vendor_id')
     ->selectRaw('
            multi_voucher_d.multi_voucher_d_id   as id,
            purchases_vendors.purchases_vendor_id as vendor_id,
            multi_voucher_d.description ,
            multi_voucher_m.action_date ,
            multi_voucher_d.amount ,
            purchases_vendors.name_'.$lang.' as vendor_name,
            "7" as type ,
            "1" as sumtion
     ');

     if(isset($params['before'])){
         $multi_voucher_c_query->where('multi_voucher_m.action_date' , '<' , $params['before'] );
     }elseif(isset($params['from']) && isset($params['to'])){
         $multi_voucher_c_query->where('multi_voucher_m.action_date' , '>=' , $params['from'] );
         $multi_voucher_c_query->where('multi_voucher_m.action_date' , '<=' , $params['to'] );
     }

     $vendor_status6          = $multi_voucher_c_query->get()->toArray();
     $multi_vouchers_c_amount = collect($vendor_status6)->sum('amount');

 //=========================================================================
        if(isset($params['total'])){

            $data   = (object) array(
                'debit'  => $payment_vouchers_amount + $multi_vouchers_d_amount + $purchase_cash_invoice_amount ,
                'credit' => $purchase_invoice_amount + $receipt_vouchers_amount + $multi_vouchers_c_amount,
            );

            $first = DB::table('purchases_vendors')
                ->where('purchases_vendor_id' , $id)
                ->selectRaw('first_term_balance , balance_nature' )
                ->first();

            if($first->balance_nature == 1 )
                $data->debit = $data->debit + $first->first_term_balance;
            else
                $data->credit = $data->credit + $first->first_term_balance;

            $data->total = $data->debit - $data->credit;


        }else{
            $data = array_merge(
                $vendor_status1,
                $vendor_status2,
                $vendor_status3,
                $vendor_status4,
                $vendor_status5,
                $vendor_status6,

            );
            $data = collect($data)->sortBy('action_date')->values()->all();

        }

        return $data;

    }
}

?>
