<?php

namespace App\Classes\Sales;
use App\Models\POS\NoticeDebtor;
use App\Models\Sales\SalesInvoice;
use App\Models\Main\Setting;
use App\Classes\Finance\DailyJournalHelper;
use App\Models\Finance\DailyJournal;


use DB;

class NoticeDebtorHelper
{
    

    function generate_daily_journal($id){


        $check = Setting::get_main_setting_by_code('notice_debtor_journal')->value ?? false ;
        if(!$check){
            return array( true ,  '' ) ;
        }

        $master     = NoticeDebtor::get_notice_debtor_m($id, 'en');
        $details    = NoticeDebtor::get_notice_debtor_d($id, 'en');
        $payments   = NoticeDebtor::get_payments( $id ,'en' );


        if(!isset($master->active) || $master->active == 0 ){
            DailyJournal::delete_daily_journal_m($master->daily_journal_m_id);
            return array( true ,  '' ) ;
        }
        
        $items      = [];
        $journal_data  = array(
            'finance_year_id'   => $master->finance_year_id  ,
            'branch_id'         => $master->branch_id ,
            'des'               => $master->description ?? 'اشعار مدين رقم '.$id ,
            'journal_date'      => $master->invoice_date ,
            'document_id'       => $id ,
            'daily_type_id'     => 34 ,
            'auto_generated'    => 1 ,
            'journal_active'    => 1 ,
            'confirmed'         => 1
        );

        if($master->daily_journal_m_id > 0 ){
            $journal_data['daily_journal_id'] = $master->daily_journal_m_id;
        }


        switch ($master->sales_invoice_type_id) {
            case '1':
               $items[]   = array(
                    'account_tree_id'   => $master->customer_account_tree_id ,
                    'cost_center_id'    => 0 ,
                    'debit'             => collect($details)->sum('new_total_with_vat')   ,
                    'credit'            =>  0 ,
                    'description'       => $master->description ?? 'اشعار مدين رقم '.$id
                );
            break;
            case '2':
                $items[]   = array(
                    'account_tree_id'   => $master->treasury_account_tree_id ,
                    'cost_center_id'    => 0 ,
                    'debit'             => collect($details)->sum('new_total_with_vat')   ,
                    'credit'            =>  0 ,
                    'description'       => $master->description ?? 'اشعار مدين رقم '.$id
                );
            break;
            case '3':
                $items[]   = array(
                    'account_tree_id'   => $master->machine_account_tree_id ,
                    'cost_center_id'    => 0 ,
                    'debit'             => collect($details)->sum('new_total_with_vat')   ,
                    'credit'            =>  0 ,
                    'description'       => $master->description ?? 'اشعار مدين رقم '.$id
                );
            break;
            case '4':
                
                $items[]   = array(
                    'account_tree_id'   => $master->treasury_account_tree_id ,
                    'cost_center_id'    => 0 ,
                    'debit'             => collect($payments)->where('payment_type' , 1)->sum('amount')   ,
                    'credit'            =>  0 ,
                    'description'       => $master->description ?? 'اشعار مدين رقم '.$id
                );

                $items[]   = array(
                    'account_tree_id'   => $master->machine_account_tree_id ,
                    'cost_center_id'    => 0 ,
                    'debit'             => collect($payments)->where('payment_type' , 2)->sum('amount')   ,
                    'credit'            =>  0 ,
                    'description'       => $master->description ?? 'اشعار مدين رقم '.$id
                );

            break;
        }


        foreach ( $details as $key => $detail ) {

            $items[]    = array(
                'account_tree_id'   => $detail->sales_revenue_id ?? 0 ,
                'cost_center_id'    => 0 ,
                'credit'            => $detail->new_total_without_vat ,
                'debit'             => 0 ,
                'description'       => $master->description ?? 'اشعار مدين رقم '.$id
            );

            $items[]    = array(
                'account_tree_id'   => $detail->tax_account_tree_id ?? 0 ,
                'cost_center_id'    => 0 ,
                'credit'            => $detail->new_total_vat ,
                'debit'             => 0 ,
                'description'       => $master->description ?? 'اشعار مدين رقم '.$id
            );

        }



        $journal = (new DailyJournalHelper)->generate_journal($journal_data , $items );

        if($journal[0]){
            
            DB::table('notice_debtors_m')
                    ->where('notice_debtor_m_id' , $id)
                    ->update( ['daily_journal_m_id' => $journal[2]] );
            return $journal;

        }else{

            $response = [
               'check' => false,
               'data'  => $journal ,
               'msg'   => $journal[1]
            ];
            header('Content-Type: application/json; charset=utf-8; ');
            header('Access-Control-Allow-Origin:*');
            header('Access-Control-Allow-Headers:*');
            echo json_encode($response);
            die();

        }



    }



}
