<?php

namespace App\Classes\Sales;
use DB;

class ProformaInvoiceHelper
{
    function get_next_codes($date, $year, $branch)
    {
        $data['year_ser'] = intval(DB::table('proforma_invoice_m')
                ->where('finance_year_id', $year)
                ->max('year_ser')) + 1;

        $data['month_ser'] = intval(DB::table('proforma_invoice_m')
                ->where('finance_year_id', $year)
                ->max('month_ser')) + 1;

        $data['branch_ser'] = intval(DB::table('proforma_invoice_m')
                ->where('branch_id', $branch)
                ->max('branch_ser')) + 1;

        return $data;
    }

    function can_edit($id)
    {

        $master     = DB::table('proforma_invoice_m')->where('proforma_invoice_m_id', $id)->first();
        // $details    = DB::table('proforma_invoice_d')->where('proforma_invoice_m_id', $id)->get();

        if( $master->quotation_id > 0  ){
            return [ false , 'The invoice cannot be modified. The quotation must be modified'] ;
        }

        

        return [ true , '' ];
    }


    function can_delete($id)
    {

        $master     = DB::table('proforma_invoice_m')->where('proforma_invoice_m_id', $id)->first();
        $details    = DB::table('proforma_invoice_d')->where('proforma_invoice_m_id', $id)->get();

        if($details->sum('delivered_quantity') > 0 ){
            return [ false , 'The invoice cannot be modified because delivery note added'] ;
        }

        if( $master->sales_invoice_id > 0  ){
            return [ false , 'The invoice cannot be modified. A sales invoice has been issued'] ;
        }

        return [ true , '' ];
    }




    function prepare_details($m_id , $quotation_id , $items ,  $price_include_vat , $stock_watch = 0){

        if($quotation_id > 0){
            $rows   =  DB::table('quotation_d')
                ->where('quotation_m_id' , $quotation_id )
                ->selectRaw('tax_percent_id , vat_per , unit_id , item_id , warehouse_id , quantity , price , item_price , total_price , item_discount , total_discount , unit_type , discount , discount_per , total_without_vat , total_with_vat , total_vat , width , height , area_width , area_height , area_quantity , description , extra_inputs')
                ->get()->toArray();
        }else{
            $rows   = ( new SalesGeneralHelper )->generate_items($items , $price_include_vat  , $stock_watch);
        }

        $return = [] ;
        foreach ($rows as $key => $row){
            $return[$key]                           = $row = (array) $row;
            $return[$key]['d_id']                   = $items[$key]['d_id'] ?? null ;
            $return[$key]['proforma_invoice_m_id']  = $m_id ;
            $return[$key]['add_user']               = auth()->user()->id; 
            $return[$key]['width']                  = $items[$key]['width'] ?? 0 ;
            $return[$key]['height']                 = $items[$key]['height'] ?? 0 ;
            $return[$key]['area_width']             = $items[$key]['area_width'] ?? 0 ;
            $return[$key]['area_height']            = $items[$key]['area_height'] ?? 0 ;
            $return[$key]['area_quantity']          = $items[$key]['area_quantity'] ?? 0 ;
            $return[$key]['description']            = $items[$key]['description'] ?? '' ;
            $return[$key]['delivered_quantity']     = $items[$key]['delivered_quantity'] ?? 0 ;
            $return[$key]['remaining_quantity']     = $items[$key]['remaining_quantity'] ?? $row['quantity'] ;
        }

        return $return;
    }

    function update_master_values($id)
    {   

        $details    = DB::table('proforma_invoice_d')->where('proforma_invoice_m_id', $id)->get();

        foreach ($details as $key => $value) {

            $sum = DB::table('delivery_note_m')
                ->join('delivery_note_d' , 'delivery_note_m.delivery_note_m_id' , '=' , 'delivery_note_d.delivery_note_m_id')
                ->where('delivery_note_m.delivery_note_active' , 1 )
                ->where('delivery_note_m.proforma_invoice_id' , $id )
                ->where('delivery_note_d.proforma_invoice_d_id' , $value->proforma_invoice_d_id )
                ->sum('quantity');

            DB::table('proforma_invoice_d')
                ->where('proforma_invoice_d_id' , $value->proforma_invoice_d_id)
                ->update( [
                    'delivered_quantity' => $sum , 
                    'remaining_quantity' => $value->quantity - $sum 
                ] );

        }

        $master     = DB::table('proforma_invoice_m')->where('proforma_invoice_m_id', $id)->first();
        $details    = DB::table('proforma_invoice_d')->where('proforma_invoice_m_id', $id)->get();

        DB::table('proforma_invoice_m')
            ->where('proforma_invoice_m.proforma_invoice_m_id', $id)
            ->update([
                'total_discount'             => $details->sum('total_discount') ,
                'total_vat'                  => $details->sum('total_vat') ,
                'total_without_vat'          => $details->sum('total_without_vat') ,
                'total_with_vat'             => $details->sum('total_with_vat') ,
                'total_price_after_discount' => $details->sum('total_without_vat') ,
                'total_delivered'            => $details->sum('delivered_quantity') ,
                
            ]);

        if($master->sales_invoice_id > 0 ){

            DB::table('proforma_invoice_m')
                ->where('proforma_invoice_m_id', $id)
                ->update([ 'proforma_invoice_status' =>  4 ] );

        }elseif( $details->sum('remaining_quantity') <= 0 ){

            DB::table('proforma_invoice_m')
                ->where('proforma_invoice_m_id', $id)
                ->update([ 'proforma_invoice_status' =>  2 ] );
        }else{

            DB::table('proforma_invoice_m')
                ->where('proforma_invoice_m_id', $id)
                ->update([ 'proforma_invoice_status' =>  1 ] );
        }




        return true;
    
    }

    function generate_daily_journal($id)
    {
        return true;
    }
}
