<?php
namespace App\Classes\Sales;

use App\Classes\General\General;
use App\Models\Finance\Currency;
use DB;

class SalesGeneralHelper
{

    function generate_items($items , $price_include_vat , $stock_watch = 0)
    {
        $rows = [];
        foreach ($items as $key => $item) {

           $x = DB::table('items')
                ->where('item_id' , $item['item_id'])
                ->first();

            $return[$key]['extra_inputs']       = json_encode($items[$key]['extra_inputs'] ?? [] );

            if(!isset($item['extra_inputs'])){
                $extra_inputs = '';
            }elseif (is_array($item['extra_inputs'])) {
                $extra_inputs = json_encode($items[$key]['extra_inputs']);
            }else{
                $extra_inputs = $item['extra_inputs'];
            }
            if(isset($item['currency_id']) && $item['currency_id'] > 0){
                $equivalent_value = Currency::get_currency($item['currency_id'])->equivalent_value;
            }
            $rows[$key]                     = (new General)->generat_vat_prices($item['price'],$item['quantity'],$item['total_discount'],$item['tax_percent_id'] ?? 1,$x->price_include_vat);
            $selectedItem                   = DB::table('items')->where('item_id', $item['item_id'])->first();
            $rows[$key]['unit_id']          = $item['unit_id'];
            $rows[$key]['item_id']          = $item['item_id'];
            $rows[$key]['warehouse_id']     = $item['warehouse_id'] ?? 0;
            $rows[$key]['quantity']         = $item['quantity'];
            $rows[$key]['price']            = $item['price'];
            $rows[$key]['currency_id']      = $item['currency_id'] ?? 0;
            $rows[$key]['foreign_currency'] = $item['foreign_currency'] ?? 0;
            $rows[$key]['discount_per']     = $item['discount_per'] ?? 0;
            $rows[$key]['equivalent_value'] = $equivalent_value ?? null;

            $rows[$key]['extra_inputs'] = $extra_inputs;

            if ($item['unit_id'] == $selectedItem->big_unit_id){
                $rows[$key]['unit_type'] = 3;
            }elseif ($item['unit_id'] == $selectedItem->mid_unit_id){
                $rows[$key]['unit_type'] = 2;
            }elseif ($item['unit_id'] == $selectedItem->small_unit_id){
                $rows[$key]['unit_type'] = 1;
            }else{
                $rows[$key]['unit_type'] = 3;
            }
        }

        return $rows;
    }
    function generate_update_items($items , $price_include_vat , $stock_watch = 0)
    {
        $rows = [];
        foreach ($items as $key => $item) {

           $x = DB::table('items')
                ->where('item_id' , $item['item_id'])
                ->first();

            $return[$key]['extra_inputs']       = json_encode($items[$key]['extra_inputs'] ?? [] );

            if(!isset($item['extra_inputs'])){
                $extra_inputs = '';
            }elseif (is_array($item['extra_inputs'])) {
                $extra_inputs = json_encode($items[$key]['extra_inputs']);
            }else{
                $extra_inputs = $item['extra_inputs'];
            }

            $rows[$key]                 = (new General)->generat_vat_prices($item['price'],$item['quantity'],$item['total_discount'],$item['tax_percent_id'] ?? 1,$x->price_include_vat);
            $selectedItem               = DB::table('items')->where('item_id', $item['item_id'])->first();
            $rows[$key]['unit_id']      = $item['unit_id'];
            $rows[$key]['item_id']      = $item['item_id'];
            $rows[$key]['warehouse_id'] = $item['warehouse_id'] ?? 0;
            $rows[$key]['quantity']     = $item['quantity'];
            $rows[$key]['price']        = $item['price'];
            $rows[$key]['extra_inputs'] = $extra_inputs;

            if ($item['unit_id'] == $selectedItem->big_unit_id){
                $rows[$key]['unit_type'] = 3;
            }elseif ($item['unit_id'] == $selectedItem->mid_unit_id){
                $rows[$key]['unit_type'] = 2;
            }elseif ($item['unit_id'] == $selectedItem->small_unit_id){
                $rows[$key]['unit_type'] = 1;
            }
        }

        return $rows;
    }
}
