<?php

namespace App\Classes\Sales;
use DB;

class SalesOrderHelper
{
    function update_master_values($id)
    {
        $sales_order = DB::table('sales_order_m')->where('sales_order_m_id', $id)->first();
        $details = DB::table('sales_order_d')->where('sales_order_m_id', $id)->get();

        $total_price = collect($details)->sum('total_price');
        $total_vat = collect($details)->sum('total_vat');

        if ($sales_order->invoice_discount){
            // Discount In Value
            if ($sales_order->discount_type == 1){
                return DB::table('sales_order_m')
                    ->where('sales_order_m.sales_order_m_id', $id)
                    ->update([
                        'total_discount'             => $sales_order->discount,
                        'total_vat'                  => $total_vat,
                        'total_without_vat'          => ($total_price - $sales_order->discount),
                        'total_with_vat'             => ($total_price - $sales_order->discount) + $total_vat,
                        'total_price_after_discount' => ($total_price - $sales_order->discount),
                    ]);
                // Discount In Percentage
            }elseif ($sales_order->discount_type == 2){
                return DB::table('sales_order_m')
                    ->where('sales_order_m.sales_order_m_id', $id)
                    ->update([
                        'total_discount'             => ((($sales_order->discount ?? 0) / 100) * $total_price),
                        'total_vat'                  => $total_vat,
                        'total_without_vat'          => ($total_price - $sales_order->discount),
                        'total_with_vat'             => ($total_price - $sales_order->discount) + $total_vat,
                        'total_price_after_discount' => ($total_price - ((($sales_order->discount ?? 0) / 100) * $total_price)),
                    ]);
            }
        }else{
            return DB::table('sales_order_m')
                ->where('sales_order_m.sales_order_m_id', $id)
                ->update([
                    'total_discount'             => 0,
                    'total_vat'                  => $total_vat,
                    'total_without_vat'          => ($total_price - $sales_order->discount),
                    'total_with_vat'             => ($total_price - $sales_order->discount) + $total_vat,
                    'total_price_after_discount' => $total_price,
                ]);
        }
    }
}
