<?php
namespace App\Http\Controllers\API\EX\V1;
use App\Http\Controllers\Controller;


class BaseController extends Controller
{

    protected $data = array();
    public function __construct()
    {

    }

    public function sendResponse($result, $message = '' )
    {
    	$response = [
            'check' => true,
            'data'  => $result,
            'msg'   => $message,
        ];
        return response()->json($response, 200);
    }

    public function sendError($error, $errorMessages = [], $code = 200)
    {
    	$response = [
            'check' => false,
            'msg' => $error,
        ];


        if(!empty($errorMessages)){
            $response['data'] = $errorMessages;
        }


        return response()->json($response, $code);
    }

}
