<?php

namespace App\Http\Controllers\API\V1\Assets;
use App\Http\Controllers\API\V1\BaseController;
use App\Models\Assets\Assets;
use Illuminate\Http\Request;
use App\Models\Main\ScreenSub;
use App\Models\Assets\AssetsCategories;
use App\Models\Finance\AccountTree;
use Illuminate\Validation\Rule;

class AssetsCategoriesController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang , Request $request)
    {
        $this->checkPermission('06-021','view');
        $this->filter = array(
            'lang'        => $lang ,
            'active'      => $request['active'] ?? 1 ,
            'rows'        => $request['rows'] ?? null ,
            'page'        => $request['page'] ?? 1 ,
            'word'        => $request['word'] ?? null
        );

        $this->return['screen_name']       = ScreenSub::get_screen_sub_by_screen_code('06-021' , $lang)->sub_title ?? '';
        $this->return['assets_categories'] = AssetsCategories::all_assets_category($this->filter);
        $this->return['account_trees']  = AccountTree::active_account_trees($lang, array('account_type' => 2, 'active' => '1'));
        $this->return['assets']            = Assets::all_assets_m($this->filter);
        return $this->sendResponse($this->return);
    }

    public function create($lang , Request $request)
    {
        $this->checkPermission('06-021','add');

        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('06-021' , $lang)->sub_title ?? '';
        $this->return['account_trees']  = AccountTree::active_account_trees($lang, array('account_type' => 2, 'active' => '1'));
        return $this->sendResponse( $this->return);
    }

    public function store(Request $request)
    {
        $this->checkPermission('06-021','add');

        $input    = $request->all();
        $insert = [
            'name_en'           => $input['name_en'],
            'name_ar'           => $input['name_ar'],
            'annual_depr_perc'  => $input['annual_depr_perc'],
            'depr_months'       => $input['depr_months'],
            'asset_acc_id'      => $input['asset_acc_id'],
            'total_depr_acc_id' => $input['total_depr_acc_id'],
            'exp_depr_acc_id'   => $input['exp_depr_acc_id'],
            'profit_loss_acc_id' => $input['profit_loss_acc_id'],
            'dev_spare_acc_id'  => $input['dev_spare_acc_id'],
            'rev_spare_acc_id'  => $input['rev_spare_acc_id'],
            'add_user'          => auth()->user()->id,
        ];

        $validator = validator()->make($insert , AssetsCategories::$rules);
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }
        $this->return['id'] = AssetsCategories::add_assets_category($insert);

        return $this->sendResponse( $this->return , trans('main.add_success') );
    }

    public function show($lang , $id )
    {
        $this->checkPermission('06-021','view');

        $this->return['screen_name']     = ScreenSub::get_screen_sub_by_screen_code('06-021' , $lang)->sub_title ?? '';
        $this->return['item']            = AssetsCategories::get_assets_category($id, $lang);
        $this->return['account_trees']   = AccountTree::active_account_trees($lang, array('account_type' => 2, 'active' => '1'));
        return $this->sendResponse( $this->return , '' );
    }

    public function update($lang, $id , Request $request)
    {
        $this->checkPermission('06-021','edit');

        $input  = $request->all();
        $update = [
            'name_en'           => $input['name_en'],
            'name_ar'           => $input['name_ar'],
            'annual_depr_perc'  => $input['annual_depr_perc'],
            'depr_months'       => $input['depr_months'],
            'asset_acc_id'      => $input['asset_acc_id'],
            'total_depr_acc_id' => $input['total_depr_acc_id'],
            'exp_depr_acc_id'   => $input['exp_depr_acc_id'],
            'profit_loss_acc_id' => $input['profit_loss_acc_id'],
            'dev_spare_acc_id'  => $input['dev_spare_acc_id'],
            'rev_spare_acc_id'  => $input['rev_spare_acc_id'],
        ];
        $update_rules = [
            'name_en' => [
                'required',
                'string',
                Rule::unique('assets_categories')->ignore($id,'asset_category_id'),
            ],
            'name_ar' => [
                'required',
                'string',
                Rule::unique('assets_categories')->ignore($id,'asset_category_id'),
            ],
        ];
        $validator  = validator()->make( $update , $update_rules);
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }

        AssetsCategories::update_assets_category($update ,$id );
        return $this->sendResponse( [] , trans('main.update_success') );
    }

    public function destroy($lang,$id)
    {
        $this->checkPermission('06-021','delete');

        AssetsCategories::delete_assets_category($id);

        return $this->sendResponse( [] , trans('main.delete_success') );
    }


    public function toggle_active($lang,$id){
        $item = AssetsCategories::get_assets_category($id,$lang);
        if($item->active){

            $this->checkPermission('06-021','delete');

            AssetsCategories::delete_assets_category($id);
            $this->return['active'] = false;

        }else{

            $this->checkPermission('06-021','edit');

            AssetsCategories::update_assets_category(array('active' => 1 ) , $id);
            $this->return['active'] = true;
        }
        return $this->sendResponse( $this->return , trans('main.update_success') );
    }

}
