<?php

namespace App\Http\Controllers\API\V1\Barbers;

use App\Http\Controllers\API\V1\BaseController;
use App\Classes\Barbers\BarberBookingHelper;
use App\Classes\General\SMS;
use App\Classes\RealTime\NotificationHelper;
use App\Models\Barbers\Barber;
use App\Models\Barbers\BarberBooking;
use App\Models\Main\ScreenSub;
use App\Models\Main\Setting;
use App\Models\Sales\Customer;
use App\Http\Controllers\API\Website\Frontend\GeneralController;
use App\Models\Main\Branch;
use App\Models\POS\BarberBooking as Booking;

use Illuminate\Http\Request;
use Illuminate\Support\Facades\DB;

class BarberBookingController extends BaseController
{
    protected $return = array();
    protected $filter = array();
    protected $days   = ["Mon" => "الاثنين", "Tue" => "الثلاثاء", "Wed" => "الاربعاء", "Thu" => "الخميس", "Fri" => "الجمعه", "Sat" => "السبت", "Sun" => "الاحد"];
    protected $time   = ['PM' => 'مساء', 'AM' => 'صباحا'];

    public function index($lang, Request $request)
    {
        if (!@in_array('1', $this->data['mypermissions']['10-004'][0]->permission ?? [])) {
            return $this->sendError('view permission needed #10-004', $this->data, 200);
        }

        $this->filter = array(
            'lang'   => $lang,
            'status' => $request['status'] ?? 1,
            'active_date' => $request['active_date'] ?? date('Y-m-d')
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('10-004', $lang)->sub_title ?? '';
        $this->return['items']       = collect(BarberBooking::all_barber_bookings($this->filter))->groupBy('barber_id');

        // Check Barbers Vacation
        $barber_in_vacation_ids = DB::table('barber_vacations')
            ->where('from_date', '<=', $request['active_date'])
            ->where('to_date', '>=', $request['active_date'])
            ->pluck('barber_id');


        if (in_array($request['active_date'], ['2024-04-07', '2024-04-08', '2024-04-09', '2024-04-10'])) {
            $this->return['barbers'] = DB::table('barber_m')
                ->where('barber_active', 1)
                // ->where('barber_m_id' , '<' , 11 )
                ->select('barber_m_id as id', 'name_' . $lang . ' as name', 'image')
                // ->whereNotIn('barber_m_id', $barber_in_vacation_ids)
                ->orderBy('barber_m.barber_m_id', 'desc')
                ->get();
        } elseif (in_array($request['active_date'], ['2024-04-11'])) {
            $this->return['barbers'] = DB::table('barber_m')
                ->where('barber_active', 1)
                ->wherein('barber_m_id', [5, 9])

                ->select('barber_m_id as id', 'name_' . $lang . ' as name', 'image')
                // ->whereNotIn('barber_m_id', $barber_in_vacation_ids)
                ->orderBy('barber_m.barber_m_id', 'desc')
                ->get();
        } elseif (in_array($request['active_date'], ['2024-04-12'])) {
            $this->return['barbers'] = DB::table('barber_m')
                ->where('barber_active', 1)
                ->wherein('barber_m_id', [6, 10, 11])
                ->select('barber_m_id as id', 'name_' . $lang . ' as name', 'image')
                // ->whereNotIn('barber_m_id', $barber_in_vacation_ids)
                ->orderBy('barber_m.barber_m_id', 'desc')
                ->get();
        } else {
            $this->return['barbers'] = DB::table('barber_m')
                ->where('barber_active', 1)
                // ->where('barber_m_id' , '<' , 11 )
                ->select('barber_m_id as id', 'name_' . $lang . ' as name', 'image')
                ->whereNotIn('barber_m_id', $barber_in_vacation_ids)
                ->orderBy('barber_m.barber_m_id', 'desc')
                ->get();
        }


        // Get Barber Day Times
        $day_name = date('l', strtotime($request['active_date']));
        foreach ($this->return['barbers'] as $key => $value) {



            if (in_array($request['active_date'], ['2024-04-07'])) {
                $this->return['barbers'][$key]->barber_work_times[] = (object) [
                    'barber_m_id'   => $value->id,
                    'day_name_en'   => 'Sunday',
                    'day_name_en'   => 'الأحد',
                    'beginning_work' => '00:00:00',
                    'end_work'      => '01:29:00'
                ];

                $this->return['barbers'][$key]->barber_work_times[] = (object) [
                    'barber_m_id'   => $value->id,
                    'day_name_en'   => 'Sunday',
                    'day_name_en'   => 'الأحد',
                    'beginning_work' => '12:00:00',
                    'end_work'      => '23:59:00'
                ];
            } elseif (in_array($request['active_date'], ['2024-04-08'])) {
                $this->return['barbers'][$key]->barber_work_times[] = (object) [
                    'barber_m_id'   => $value->id,
                    'day_name_en'   => 'Monday',
                    'day_name_en'   => 'الاثنين',
                    'beginning_work' => '00:00:00',
                    'end_work'      => '01:29:00'
                ];

                $this->return['barbers'][$key]->barber_work_times[] = (object) [
                    'barber_m_id'   => $value->id,
                    'day_name_en'   => 'Monday',
                    'day_name_en'   => 'الاثنين',
                    'beginning_work' => '12:00:00',
                    'end_work'      => '23:59:00'
                ];
            } elseif (in_array($request['active_date'], ['2024-04-09'])) {
                $this->return['barbers'][$key]->barber_work_times[] = (object) [
                    'barber_m_id'   => $value->id,
                    'day_name_en'   => 'Tuesday',
                    'day_name_en'   => 'الثلاثاء',
                    'beginning_work' => '00:00:00',
                    'end_work'      => '01:29:00'
                ];

                $this->return['barbers'][$key]->barber_work_times[] = (object) [
                    'barber_m_id'   => $value->id,
                    'day_name_en'   => 'Tuesday',
                    'day_name_en'   => 'الثلاثاء',
                    'beginning_work' => '12:00:00',
                    'end_work'      => '23:59:00'
                ];
            } elseif (in_array($request['active_date'], ['2024-04-10'])) {
                $this->return['barbers'][$key]->barber_work_times[] = (object) [
                    'barber_m_id'   => $value->id,
                    'day_name_en'   => 'Wednesday',
                    'day_name_en'   => 'الأربعاء',
                    'beginning_work' => '00:00:00',
                    'end_work'      => '04:59:00'
                ];
            } elseif (in_array($request['active_date'], ['2024-04-11'])) {
                $this->return['barbers'][$key]->barber_work_times[] = (object) [
                    'barber_m_id'   => $value->id,
                    'day_name_en'   => 'Thursday',
                    'day_name_en'   => 'الخميس',
                    'beginning_work' => '14:00:00',
                    'end_work'      => '23:59:00'
                ];
            } elseif (in_array($request['active_date'], ['2024-04-12'])) {
                $this->return['barbers'][$key]->barber_work_times[] = (object) [
                    'barber_m_id'   => $value->id,
                    'day_name_en'   => 'Friday',
                    'day_name_en'   => 'الجمعه',
                    'beginning_work' => '13:00:00',
                    'end_work'      => '23:59:00'
                ];
            } else {
                $this->return['barbers'][$key]->barber_work_times = DB::table('barber_d')
                    ->select('beginning_work', 'end_work', 'is_day_off')
                    ->where('barber_m_id', $value->id)
                    ->where('day_name_en', $day_name)
                    ->get();
            }
        }

        // Check If Day is Off Or Not and Get Day Times
        $checkDateWorkTime = DB::table('barber_shop_times')->where('day_name_en', $day_name)->first();
        $this->return['is_day_off'] = ($checkDateWorkTime->is_day_off == 1) ? true : false;

        // Return Times Based On Day Times
        $beginning_work = $checkDateWorkTime->beginning_work;
        $end_work       = $checkDateWorkTime->end_work;

        $this->return['times'] = DB::table('b_times')
            ->select('time_id as id', 'time_title as time', 'group_id')
            ->where('time_title', '>=', $beginning_work)
            ->where('time_title', '<=', $end_work)
            ->orderBy('time_title')
            // ->where('time_title' , '>' , date("H:i:s" , strtotime("+20 minutes")))
            ->get();

        //        $this->return['times'] = DB::table('b_times')
        //            ->select('time_id as id', 'time_title as time', 'group_id')
        //            ->get();

        // Get Interval Minutes
        $first  = strtotime($this->return['times'][0]->time);
        $second = strtotime($this->return['times'][1]->time);
        $this->return['interval_minutes'] = (int) date('i', $second - $first);

        return $this->sendResponse($this->return);
    }

    public function create($lang, Request $request)
    {
        // if(!@in_array('2', $this->data['mypermissions']['10-004'][0]->permission ?? [])){
        //     return $this->sendError('view permission needed #10-004', $this->data, 200);
        // }

        // Check If Barber In Vacation
        $checkBarberVacation = DB::table('barber_vacations')
            ->where('barber_id', $request['barber_id'])
            ->whereDate('from_date', '<=', $request['barber_booking_date'])
            ->whereDate('to_date', '>=', $request['barber_booking_date'])
            ->first();

        if (!is_null($checkBarberVacation)) {
            return $this->sendError(trans('error.Barber is In Vacation'));
        }

        // Check If Barber Has Booking In Selected Time
        $barber_bookings = DB::table('barber_bookings')
            ->where('barber_booking_date', $request['barber_booking_date'])
            ->where('barber_id', $request['barber_id'])
            ->where('barber_booking_status', 1)
            ->where('barber_booking_active', 1)
            ->whereRaw('find_in_set(' . $request['start_time'] . ', time_blocks_ids)')
            ->get();

        if (count($barber_bookings) > 0) {
            return $this->sendError(trans('error.This Time Not Available For Selected Barber'));
        } else {
            $categorys = DB::table('items')
                ->join('categorys', 'items.category_id', '=', 'categorys.category_id')
                ->leftjoin('taxes', 'items.tax_id', '=', 'taxes.tax_id')
                ->selectRaw('
                    items.item_id as item_id,
                    items.name_' . $lang . ' as item_name,
                    items.description ,
                    items.sale_price as item_price,


             
                    if(price_include_vat = 1 , (sale_price / ( 1 + ( taxes.tax_percentage / 100 ) ) ) , sale_price ) as price_without_vat,
                    if(price_include_vat = 1 , sale_price , sale_price * ( 1 + ( taxes.tax_percentage / 100 ) )  ) as price_with_vat,
                    if(price_include_vat = 1 , (sale_price - (sale_price / ( 1 + ( taxes.tax_percentage / 100 ) ) ) ) , ( sale_price * ( taxes.tax_percentage / 100 ) )  ) as price_vat ,
                    taxes.tax_percentage as vat_percentage,

                    items.sale_price as item_price,
                    items.image as item_image,
                    items.time_blocks as item_time_blocks,
                    items.category_id as category_id,
                    categorys.name_' . $lang . ' as category_name
                ')
                ->where('items.item_active', 1)
                ->where('pos_item', 1)
                ->get()->groupBy('category_id')->all();

            $this->return['categorys'] = [];

            foreach ($categorys as $category_key => $category_value) {
                $this->return['categorys'][$category_key] = array(
                    'category_id'   => $category_value[0]->category_id,
                    'category_name' => $category_value[0]->category_name,
                    'services'      => []
                );

                $services = collect($category_value)->groupBy('item_id')->toArray();
                foreach ($services as $service_key => $service_value) {
                    $this->return['categorys'][$category_key]['services'][$service_key] = array(
                        'id'          => $service_value[0]->item_id,
                        'name'        => $service_value[0]->item_name,
                        'description' => $service_value[0]->description,
                        'price_without_vat'  => $service_value[0]->price_without_vat,
                        'price_vat'   => $service_value[0]->price_vat,
                        'price_with_vat' => $service_value[0]->price_with_vat,
                        'vat_percentage' => $service_value[0]->vat_percentage,
                        'image'       => $service_value[0]->item_image,
                        'time_blocks' => $service_value[0]->item_time_blocks,
                        'category_id' => $category_value[0]->category_id,
                    );
                }
            }

            //            $this->return['services']  = DB::table('b_services')
            //                ->select('service_id as id', 'category_id', 'name_'.$lang.' as name', 'price', 'price_with_vat', 'tax_value', 'image')
            //                ->where('service_active', 1)
            //                ->get();

            $this->return['branchs']   = DB::table('b_branchs')
                ->select('branch_id as id', 'name_' . $lang . ' as name', 'address', 'image')
                ->where('branch_active', 1)
                ->get();

            //            $this->return['barber_customers'] = DB::table('barber_customers')
            //                ->select('barber_customer_id as id', 'name', 'mobile')
            //                ->get();

            $this->return['barber_customers'] = DB::table('customers')
                ->where('customer_type_id', 2)
                ->select('customer_id as id', 'name_' . $lang . ' as name', 'phone as mobile')
                ->get();
            $this->return['barber'] = Barber::get_barber_m($request['barber_id'], $lang);
        }


        $this->return['default_customer'] = Customer::get_customer(Setting::get_main_setting_by_code('default_customer')->value ?? 0, $lang);

        return $this->sendResponse($this->return);
    }

    public function store($lang, Request $request)
    {
        if (!@in_array('2', $this->data['mypermissions']['10-004'][0]->permission ?? [])) {
            return $this->sendError('view permission needed #10-004', $this->data, 200);
        }
        try {
            app()->setLocale($lang);
            $insert = $request->only('services', 'branch_id', 'booking_date', 'start_time', 'coupon_code', 'barber_id', 'points', 'customer_mobile', 'notes');
            $times = collect((new GeneralController)->get_available_times($insert['booking_date'], $insert['barber_id'], $insert['services'], $lang))->pluck('time_id')->toArray();

            // check if request come from Front End
            $request->validate(['customer_mobile' => 'required|string|min:8']);

            $customer = DB::table('customers')->where('phone', $insert['customer_mobile'])->first();
            if (!$customer) {
                return $this->sendError(trans('error.Customer Not Found'), []);
            }
            $customer_id = $customer->customer_id;
            $customer_mobile = $customer->phone;




            $validator = validator()->make($insert, Booking::$rules);

            if ($validator->fails()) {
                return $this->sendError(trans('error.Error In Validation'), $validator->errors());
            }


            $services = DB::table('items')
                ->leftjoin('taxes', 'items.tax_id', '=', 'taxes.tax_id')
                ->whereIn('item_id', $insert['services'])
                ->selectRaw('
                item_id as id ,
                items.name_' . $lang . ' as name ,
                image ,
                description ,
                category_id ,
                taxes.tax_percentage as tax_percent ,
                time_blocks ,
                if(price_include_vat = 1 , sale_price , sale_price * ( 1 + ( taxes.tax_percentage / 100 ) )  ) as price_with_vat ,
                if(price_include_vat = 1 , (sale_price - (sale_price / ( 1 + ( taxes.tax_percentage / 100 ) ) ) ) , ( sale_price * ( taxes.tax_percentage / 100 ) )  ) as price_vat ,
                if(price_include_vat = 1 , (sale_price / ( 1 + ( taxes.tax_percentage / 100 ) ) ) , sale_price ) as price_without_vat,
                item_active as service_active
            ')->get();

            $insert['total_with_vat']    = collect($services)->sum('price_with_vat');
            $insert['total_without_vat'] = collect($services)->sum('price_without_vat');
            $insert['total_vat']         = collect($services)->sum('price_vat');
            $insert['needed_blocks']     = collect($services)->sum('time_blocks');


            if ($insert['needed_blocks'] < 1) {
                return $this->sendError(trans('error.Error In Time'), [$services]);
            }

            $needed_blocks      = ceil($insert['needed_blocks'] / 5);

            $time_blocks_ids    = DB::table('b_times')
                ->where('time_id', '>=', $insert['start_time'])
                ->take($needed_blocks + 1)
                ->pluck('time_id')
                ->toArray();

            $insert['end_time']        = end($time_blocks_ids);

            if (count($time_blocks_ids) > 1) {
                unset($time_blocks_ids[count($time_blocks_ids) - 1]);
            }

            if ($time_blocks_ids[0] != 185) {
                foreach ($time_blocks_ids as $t) {
                    if (!in_array($t, $times)) {
                        return $this->sendError(trans('error.Error In Time'), $times);
                    }
                }
            }

            $insert['services']        = (is_array($insert['services'] ?? '')) ? implode(',', $insert['services']) : $insert['services'];
            $insert['time_blocks_ids'] = implode(',', $time_blocks_ids);


            $branch_id   = Branch::get_branch($insert['branch_id'], $lang)->id;
            $services_ids = $request['services'];

        $services       = DB::table('items')->whereIn('item_id', $insert['services'])->get();
        
        // check if all services are from same type
        $categorys      = DB::table('categorys')->whereIn('category_id', $services->pluck('category_id'))->get();
        $service_types   = collect($categorys);
        if($service_types->count() > 1){
            return $this->sendError(trans('error.you_cant_choise_services_from_different_types'));
        }
        
        

        $needed_blocks  = collect($services)->sum('time_blocks');



            // check if customer has another booking in same day
            $counter = DB::table('barber_bookings')
                ->where('barber_booking_date', $insert['booking_date'])
                ->where('barber_customer_id', $customer_id)
                ->where('barber_booking_active', 1)
                ->count();

            if ($counter > 1) {
                return $this->sendError(trans('error.customer_has_booking'), []);
            }

            //check if Coupon and Points provided
            if ($request->filled('coupon_code') && $request->filled('points')) {
                return $this->sendError(trans('error.Coupon and Points can not be used together'), []);
            }

            // check if coupon is provided
            if ($request->filled('coupon_code')) {

                $coupon = DB::table('coupons')
                    ->where('coupon_code', $request['coupon_code'])
                    ->whereRaw("FIND_IN_SET(1,platforms_id)")
                    ->where('start_date', '<=',  date("Y-m-d"))
                    ->where('end_date', '>=',  date("Y-m-d"))
                    ->first();

                // Check if coupon exists
                if (!$coupon) {
                    return $this->sendError(trans('error.Coupon Not Found'));
                }

                // Check if coupon is valid for customer
                $counter = DB::table('barber_bookings')
                    ->where('barber_bookings.barber_customer_id', $customer_id)
                    ->where('coupon_code', $request['coupon_code'])
                    ->count();

                if ($counter >= $coupon->allowed_count) {
                    return $this->sendError(trans('error.Coupon used before'));
                }

                // If Isset Coupon Get Coupon Discount Value and Calc Total Without Vat
                if ($coupon->coupon_type == 1) {
                    $insert['coupon_discount'] = $coupon->discount;
                } else {
                    $discount_per = ($coupon->discount / 100);
                    $insert['coupon_discount'] = ($insert['total_without_vat'] * $discount_per);
                }
            }

            // check if points provided
            if ($request->filled('points')) {

                // check if minimum amount invoice is valid to use points
                $min_amount_invoice = Setting::get_main_setting_by_code('min_amount_invoice')->value ?? 0;
                if ($insert['total_without_vat'] < $min_amount_invoice) {
                    return $this->sendError(trans('error.minimum amount invoice to use points is') . $min_amount_invoice, []);
                }

                // check if customer has enough points to use
                $customer_points = DB::table('customers')->where('customer_id', $customer_id)->first()->wallet_points ?? 0;
                if ($request->points > $customer_points) {
                    return $this->sendError(trans('error.You do not have enough points to use'), []);
                }

                // check min points 
                if ($request->points < 10) {
                    return $this->sendError(trans('error.minimum points to use is') . 10, []);
                }

                // check max points
                if ($request->points > 100) {
                    return $this->sendError(trans('error.maximum points to use is') . 100, []);
                }

                // check if points is multible of 5
                if ($request->points % 5 !== 0) {
                    return $this->sendError(trans('error.points must be multiple of 5'), []);
                }

                // 1- get how many points equal to 1 SAR
                $points_count_sar_usage = Setting::get_main_setting_by_code('points_count_sar_usage')->value ?? 0;
                if ($points_count_sar_usage == 0) {
                    return $this->sendError('error.points_count_sar_usage can not be 0.', []);
                }

                // 2- calculate points discount
                $insert['points_discount'] = $request->points /  $points_count_sar_usage;
            }

            // Ensure defaults if discounts coupon or points not set
            $insert['coupon_discount'] = $insert['coupon_discount'] ?? 0;
            $insert['points_discount'] = $insert['points_discount'] ?? 0;

            // توزيع الخصم على مستوى الخدمات
            $discount_total = $insert['coupon_discount'] + $insert['points_discount'];
            $new_total_vat = 0;
            $new_total_with_vat = 0;
            $insert['total_after_discounts'] = $insert['total_without_vat'] - $discount_total;
            if ($discount_total > 0 && $insert['total_without_vat'] > 0) {
                foreach ($services as $service) {
                    // نسبة الخدمة من الإجمالي
                    $service_share = $service->price_without_vat / $insert['total_without_vat'];

                    // الخصم الخاص بالخدمة
                    $service_discount = $discount_total * $service_share;
                    // السعر الجديد بدون الضريبة بعد الخصم
                    $new_price_without_vat = $service->price_without_vat - $service_discount;

                    // الضريبة الجديدة = السعر بعد الخصم × نسبة الضريبة
                    $new_vat = $new_price_without_vat * ($service->tax_percent / 100);

                    $new_total_vat += $new_vat;
                    $new_total_with_vat += $new_price_without_vat + $new_vat;
                }

                $insert['total_vat'] = $new_total_vat;
                $insert['total_price'] = $new_total_with_vat;
            } else {
                // في حالة مفيش خصم خالص
                $insert['total_price'] = $insert['total_after_discounts'] + $insert['total_vat'];
            }
            $insert['total_price'] = $insert['total_after_discounts'] + $insert['total_vat'];

            //------------------- gain new points based on total without vat before discounts  -----------------------------
            // 1- get how much SAR equals 1 point
            $amount_sar_invoice = Setting::get_main_setting_by_code('amount_sar_invoice')->value ?? 0;

            // 2- Calculate new points based on total_without_vat
            $insert['new_points'] = (int) round(($insert['total_without_vat']) / $amount_sar_invoice);
            $insert['service_id']         = implode(',', $services_ids);

            $erp_id = DB::table('barber_bookings')->insertGetId([
                'barber_id'                => $insert['barber_id'],
                'barber_customer_id'       => $customer_id,
                'services'                 => $insert['service_id'],
                'time_blocks_ids'          => $insert['time_blocks_ids'],
                'needed_blocks'            => $needed_blocks,
                'branch_id'                => $branch_id,
                'barber_booking_date'      => $insert['booking_date'],
                'start_time'               => $insert['start_time'],
                'end_time'                 => $insert['end_time'],
                'coupon_code'              => $insert['coupon_code'] ?? 0,
                'coupon_discount'          => $insert['coupon_discount'] ?? 0, // خصم الكوبون
                'points_discount'          => $insert['points_discount'] ?? 0, // خصم البوينت
                'total_price'              => $insert['total_price'], // السعر ش ض والخصم
                'total_vat'                => $insert['total_vat'], // الضريبة
                'total_without_vat'        => $insert['total_without_vat'], // السعر قبل الضريبة
                'total_with_vat'           => $insert['total_with_vat'], // السعر شامل الضريبة
                'add_user'                 => $customer_id,
                'new_points'               => $insert['new_points'] ?? 0,
                'used_points'              => $insert['points'] ?? 0,
            ]);
            // update notes for the customer
            DB::table('customers')->where('customer_id', $customer_id)->update(['notes' => $insert['notes'] ?? null]);

            // send notification to the customer
            $this->return['erp_data'] = DB::table('barber_bookings')->where('barber_booking_id', $erp_id)->first();
            $barber_name = DB::table('barber_m')->where('barber_m_id', $insert['barber_id'])->first()->name_ar ?? '';
            $time_title = DB::table('b_times')->where('time_id', $insert['start_time'])->first()->time_title ?? '';
            $day_title  = $this->days[date("D", strtotime($insert['booking_date']))];
            $message = "ضيفنا العزيز نود تأكيد موعدكم  يوم " . $day_title . " الموافق " . $insert['booking_date'] . " الساعه " . date("h:i", strtotime($time_title)) . " " . $this->time[date("A", strtotime($time_title))] . " مع " . $barber_name . " في فرع الرياض https://maps.app.goo.gl/wJ4RvLjnFdHCFbV3A?g_st=iw";
            $this->return['content'] = (new SMS)->send("966" . $customer_mobile, $message);
            DB::table('notifications')->insertGetId(array(
                'title'         => 'New Booking',
                'description'   => $message,
                'date'          => date('Y-m-d H:i')
            ));

            return $this->sendResponse($this->return['content'], trans('main.Booking Has Been Registered'));
        } catch (\Throwable $e) {
            return $this->sendError($e->getMessage(), []);
        }
    }

    public function show($lang, $id)
    {
        if (!@in_array('1', $this->data['mypermissions']['10-004'][0]->permission ?? [])) {
            return $this->sendError('view permission needed #10-004', $this->data, 200);
        }
        // check if booking id exists
        $booking = DB::table('barber_bookings')->where('barber_booking_id', $id)->first();
        if (!$booking) {
            return $this->sendError(trans('error.Barber Booking Not Found'));
        }
        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('10-004', $lang)->sub_title ?? '';
        $this->return['data']        = BarberBooking::get_barber_booking($id, $lang);
        $services = explode(',', $this->return['data']->services);
        $this->return['services'] = DB::table('items')
            ->select('item_id as id', 'name_' . $lang . ' as name', 'sale_price as price', 'description')
            ->whereIn('item_id', $services)
            ->get();

        return $this->sendResponse($this->return);
    }

    public function check_booking_services_blocks($lang, Request $request)
    {
        $insert = $request->only('barber_id', 'services', 'barber_booking_date', 'start_time');
        return (new BarberBookingHelper)->checkBookingServiceBlocks($insert['barber_id'], $insert['services'], $insert['barber_booking_date'], $insert['start_time']);
    }

    public function cancel_barber_booking($lang, $id)
    {
        if (!@in_array('3', $this->data['mypermissions']['10-004'][0]->permission ?? [])) {
            return $this->sendError('view permission needed #10-004', $this->data, 200);
        }

        $barber_booking = DB::table('barber_bookings')->where('barber_booking_id', $id)->first();

        if (is_null($barber_booking)) {
            return $this->sendError(trans('error.Barber Booking Not Found'));
        }

        if ($barber_booking->barber_booking_status == 3) {
            return $this->sendError(trans('error.Barber Booking Already Rejected'));
        }

        //        DB::table('barber_bookings')->where('barber_booking_id', $id)->update(['barber_booking_status' => 3]);

        DB::table('barber_bookings')->where('barber_booking_id', $id)->delete();
        $count = DB::table('barber_bookings')
            ->where([
                ['barber_booking_active', 1],
                ['barber_booking_date', date('Y-m-d')],
                ['has_invoice', 0],
            ])->count();
        (new NotificationHelper)->send_notifications($count);
        return $this->sendResponse([], trans('main.Booking Canceled'));
    }

    //    public function get_available_times($lang, Request $request)
    //    {
    //        $insert = $request->only('barber_id', 'services', 'b_booking_date');
    //
    //        $services = DB::table('b_services')->whereIn('service_id', $insert['services'])->get();
    //
    //        $chairs_number  = 1;
    //        $needed_blocks  = collect($services)->sum('time_blocks');
    //        $times          = DB::table('b_times')->get();
    //        $bookings       = DB::table('bookings')
    //            ->where('barber_booking_date', $insert['b_booking_date'])
    //            ->where('barber_booking_status', 1)
    //            ->where('barber_booking_active', 1)
    //            ->get();
    //
    //        if (count($bookings) > 0){
    //            foreach ($times as $key => $value){
    //                $bookingsCount = DB::table('bookings')
    //                    ->where('barber_booking_date', $insert['b_booking_date'])
    //                    ->where('barber_id', $insert['barber_id'])
    //                    ->where('barber_booking_status', 1)
    //                    ->where('barber_booking_active', 1)
    //                    ->whereRaw('find_in_set('.$value->time_id.', time_blocks_ids)')
    //                    ->count();
    //                if ($bookingsCount >= $chairs_number){
    //                    unset($times[$key]);
    //                    for ($i=1; $i < $needed_blocks; $i++){
    //                        unset($times[$key-$i]);
    //                    }
    //                }
    //            }
    //        }
    //
    //        return $this->sendResponse($times);
    //    }
}
