<?php

namespace App\Http\Controllers\API\V1\Elevators;

use App\Classes\General\Upload;
use App\Http\Controllers\API\V1\BaseController;
use App\Models\Elevators\ElevatorModels;
use App\Models\Elevators\ElevatorRModels;
use App\Models\Elevators\ElevatorsQuotation;
use App\Models\Elevators\ElevatorTypes;
use App\Models\Main\Delegate;
use App\Models\Main\ScreenSub;
use App\Models\Sales\Customer;
use App\Models\Sales\SalesAgent;
use Illuminate\Http\Request;
use App\Models\Main\Branch;

use Illuminate\Support\Facades\Crypt;
use Illuminate\Support\Facades\DB;
use Illuminate\Support\Facades\File;
use App\Classes\Excel\DataImport;
use App\Models\Elevators\ElevatorPayments;
use App\Models\Finance\Tax;
use Excel;




class ElevatorsQuotationController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang, Request $request)
    {
        if(isset($_GET['xxx'])){
            $file_array = Excel::toArray(new DataImport, public_path('contracts.xls') )[0];

            // return $this->sendResponse($file_array);

            // foreach($file_array as $row){


            //     $row['contract_date'] = explode('/', $row['contract_date'])[2]."-".explode('/', $row['contract_date'])[1]."-".explode('/', $row['contract_date'])[0];
            //     $row['payment_date'] = explode('/', $row['payment_date'])[2]."-".explode('/', $row['payment_date'])[1]."-".explode('/', $row['payment_date'])[0];
            //     $customer_id = DB::table('customers')
            //         ->where('name_ar' , $row['c_name'])
            //         ->first()
            //         ->customer_id ?? 0;

            //     if($customer_id == 0 ){
            //         $customer_id = DB::table('customers')->insertGetId([
            //             'name_en'           => $row['c_name'] ,
            //             'name_ar'           => $row['c_name'] ,
            //             'account_tree_id'   => 182 ,
            //             'customer_type_id'  => 1
            //         ]);
            //     }

            //     $delegate_id = DB::table('delegates')
            //         ->where('name_ar' , $row['delegate'])
            //         ->first()
            //         ->delegate_id ?? 0;

            //     if($delegate_id == 0 ){
            //         $delegate_id = DB::table('delegates')->insertGetId([
            //             'name_en'   => $row['delegate'] ,
            //             'name_ar'   => $row['delegate'] ,
            //             'branchs'   => 1
            //         ]);
            //     }

            //     $contract_id = DB::table('elevators_quotations')
            //         ->where('invoice_code' , $row['contract_number'])
            //         ->where('is_contract' , 1 )
            //         ->first()
            //         ->quotation_id ?? 0;

            //     // $payment_id  = DB::table('quotations_payments')
            //     //     ->where('quotation_id' , $contract_id)
            //     //     ->first()
            //     //     ->payment_id  ?? 0;

            //     if($contract_id == 0){
            //         $contract_id = DB::table('elevators_quotations')->insertGetId([
            //             'date'              => date("Y-m-d" , strtotime($row['contract_date'])) ,
            //             'description'       => $row['details'] ,
            //             'price'             => $row['contract_amount'] ,
            //             'customer_id'       => $customer_id ,
            //             'delegate_id'       => $delegate_id ,
            //             'admin_response'    => 2 ,
            //             'client_response'   => 2 ,
            //             'is_contract'       => 1 ,
            //             'contract_status'   => 1 ,
            //             'invoice_code'      => $row['contract_number']
            //         ]);

            //     }

            //     if($row['payment_amount'] > 0 ){
            //         $payment_id  = DB::table('quotations_payments')->insertGetId([
            //             'start_date'        => date("Y-m-d" , strtotime($row['payment_date'])) ,
            //             'end_date'          => date("Y-m-t" , strtotime($row['payment_date'])) ,
            //             'quotation_id'      => $contract_id ,
            //             'payment_name'      => "" ,
            //             'percentage'        => ceil( $row['payment_amount'] / $row['contract_amount'] ) ,
            //             'details'           => "" ,
            //             'amount'            => $row['contract_amount'] ,
            //             'paid'              => $row['payment_amount'] ,
            //             'remaining'         => $row['contract_amount'] - $row['payment_amount']  ,
            //             'status'            => 3
            //         ]);

            //         $receipt_id = DB::table('receipt_vouchers')->insertGetId([
            //             'branch_id'                 => 1 ,
            //             'finance_year_id'           => 5 ,
            //             'action_date'               => date("Y-m-d" , strtotime($row['payment_date'])) ,
            //             'document_number'           => $row['voucher_number'] ,
            //             'from_type'                 => 3 ,
            //             'from_customer_id'          => $customer_id ,
            //             'to_type'                   => 3 ,
            //             'to_bank_id'                => 1 ,
            //             'amount'                    => $row['payment_amount'] ,
            //             'description'               => 'دفعه من عقد رقم   '.$row['contract_number'] ,
            //             'auto_generated'            => 0 ,
            //             'receipt_voucher_active'    => 1

            //         ]);
            //         DB::table('quotations_payments')
            //             ->where('payment_id' , $payment_id )
            //             ->update(['voucher_id' => $receipt_id]);

            //         DB::table('quotations_payments_installments')->insertGetId([
            //             'payment_id'    => $payment_id ,
            //             'voucher_id'    => $receipt_id ,
            //             'amount'        => $row['payment_amount']
            //         ]);

            //     }
            // }

            // return $this->sendResponse($file_array);

            // $all = DB::table('quotations_payments_installments')->get();

            // foreach ($all as $key => $value) {
            //     DB::table('receipt_vouchers_d')
            //         ->insert([
            //             'receipt_voucher_d_id'  => $value->id ,
            //             'receipt_voucher_m_id'  => $value->voucher_id ,
            //             'document_id'           => $value->payment_id ,
            //             'amount'                => $value->amount
            //         ]);
            // }

        }
        $this->checkPermission('12-001','view');
        $check_view = DB::table('users')->where('id' , auth()->user()->id)->value('view_all_data') ?? 1;

        $this->filter = array(
            'lang'              => $lang ,
            'active'            => $request['active'] ?? 1 ,
            'admin_response'    => $request['admin_response'] ?? null ,
            'client_response'   => $request['client_response'] ?? null ,
            'is_contract'       => $request['is_contract'] ?? null ,
            'rows'              => $request['rows'] ?? null ,
            'contract_status'   => $request['contract_status'] ?? null ,
            'page'              => $request['page'] ?? null ,
            'word'              => $request['word'] ?? null ,
            'customer_id'       => $request['customer_id'] ?? null ,
            'type_id'           => $request['type_id'] ?? null ,
            'delegate_id'       => $request['delegate_id'] ?? null ,
            'add_user'          => $check_view == 0 ? auth()->user()->id : null,

        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('12-002', $lang)->sub_title ?? '';
        $this->return['items']       = ElevatorsQuotation::all_quotations($this->filter);
        $this->return['types']       = ElevatorTypes::get_type_lookup($lang);
        $this->return['delegates']   = Delegate::all_delegates(array('active' => 1,'lang' => $lang));

        return $this->sendResponse($this->return);
    }

    public function create($lang, Request $request)
    {
        $this->checkPermission('12-002','add');

        $this->return['screen_name']        = ScreenSub::get_screen_sub_by_screen_code('12-002', $lang)->sub_title ?? '';
        $this->return['customers']          = Customer::all_customers(array('active' => 1,'lang' => $lang));
        $this->return['sales_agents']       = SalesAgent::all_sales_agents(array('active' => 1,'lang' => $lang));
        $this->return['delegates']          = Delegate::all_delegates(array('active' => 1,'lang' => $lang));
        $this->return['elevator_payments']  = ElevatorPayments::all_payments(['lang'=>$lang,'active'=>1]);
        $this->return['types']              = ElevatorTypes::get_type_lookup($lang);
        $this->return['citys']              = DB::table('citys')->selectRaw('city_id,name_'.$lang.' as name')->get();
        $this->return['taxes']              = Tax::all_taxes(['lang' => $lang , 'active' => 1 ]);

        return $this->sendResponse($this->return);
    }

    public function store($lang, Request $request)
    {
        $this->checkPermission('12-002','add');

        $inputs = $request->all();

        $master_seed = [
            'date'              => $inputs['date'] ?? date('Y-m-d'),
            'description'       => $inputs['description'] ?? null,
            'book_contract_number'  => $inputs['book_contract_number'] ?? null,
            'customer_id'       => $inputs['customer_id'] ?? 0,
            'sales_agent_id'    => $inputs['sales_agent_id'] ?? 0,
            'delegate_id'       => $inputs['delegate_id'] ?? 0,
            'type_id'           => $inputs['type_id'] ?? 1,
            'city_id'           => $inputs['city_id'] ?? 0,
            'tax_id'            => $inputs['tax_id'] ?? 0,
            'warranty'          => $inputs['warranty'] ?? null,
            'elevators_count'   => $inputs['elevators_count'] ?? 1,
            'floors_count'      => $inputs['floors_count'] ?? 0,
            'add_user'          => auth()->user()->id
        ];
        if($master_seed['tax_id'] > 0 ){
            $master_seed['tax_percentage']      = DB::table('taxes')->where('tax_id',$master_seed['tax_id'])->value('tax_percentage');
            $master_seed['price_without_vat']   = ($inputs['price_with_vat'] / (1+ intval($master_seed['tax_percentage'])/100));
            $master_seed['price_with_vat']      = $inputs['price_with_vat'];

        }else{
            $master_seed['tax_percentage']      = 0;
            $master_seed['price_with_vat']      = $inputs['price_with_vat'];
            $master_seed['price_without_vat']   = $inputs['price_with_vat'];

        }
        $validator = validator()->make($master_seed, ElevatorsQuotation::$master_rules);

        if($validator->fails()){
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }

        DB::beginTransaction();
        if (isset($inputs['models']) && is_array($inputs['models'])){
            $models_id = [];
            foreach ($inputs['models'] as $item){
                $insert_master = [
                    'name_en'           => $item['name_en'],
                    'name_ar'           => $item['name_ar'],
                    'elevator_type_id'  => $master_seed['type_id'],
                    'add_user'          => auth()->user()->id
                ];

                $validator = validator()->make($insert_master, ElevatorRModels::$master_rules);

                if($validator->fails()){
                    return $this->sendError(trans('error.add_fails'), $validator->errors());
                }

                $model_m_id = ElevatorRModels::add_model_m($insert_master);

                if (isset($item['items']) && is_array($item['items'])){
                    foreach ($item['items'] as $detail){
                        $insert_details = array(
                            'model_m_id'        => $model_m_id,
                            'item_name'         => $detail['item_name'],
                            'description'       => $detail['description'],
                        );

                        $validator = validator()->make($insert_details, ElevatorRModels::$details_rules);

                        if($validator->fails()){
                            return $this->sendError(trans('error.add_fails'), $validator->errors());
                        }
                        ElevatorRModels::add_model_d($insert_details);
                    }
                }
                $models_id[] = $model_m_id;
            }
        }
        $master_seed['models_id'] = implode(',' , $models_id) ?? null ;

        $m_id = ElevatorsQuotation::add_quotation($master_seed);

        if (isset($inputs['payments']) && is_array($inputs['payments'])){
            foreach ($inputs['payments'] as $item){
                $details_seed = array(
                    'quotation_id'        => $m_id,
                    'payment_name'        => $item['payment_name'] ?? null,
                    'percentage'          => $item['percentage'] ?? 0,
                    'details'             => $item['details'] ?? null,
                    'amount'              => $item['amount'] ?? 0,
                    'remaining'           => $item['amount'] ?? 0,

                );

                $validator = validator()->make($details_seed, ElevatorsQuotation::$details_rules);

                if($validator->fails()){
                    return $this->sendError(trans('error.add_fails'), $validator->errors());
                }
                ElevatorsQuotation::add_payment($details_seed);
            }
        }

        DB::commit();
        return $this->sendResponse($m_id, trans('main.add_success'));
    }

    public function show($lang, $id)
    {
        $this->checkPermission('12-002','view');
        $encrypted_data = array('id'=>$id);
        $this->return['screen_name']        = ScreenSub::get_screen_sub_by_screen_code('12-002', $lang)->sub_title ?? '';
        $this->return['master']             = ElevatorsQuotation::get_quotation($id, $lang);
        $this->return['details']            = ElevatorsQuotation::get_quotation_payments(array('quotation_id' => $id,'lang' => $lang));
        $this->return['attachments']        = DB::table('quotations_attachments')->where('quotation_id',$id)->get();
        $this->return['customers']          = Customer::all_customers(array('active' => 1,'lang' => $lang));
        $this->return['sales_agents']       = SalesAgent::all_sales_agents(array('active' => 1,'lang' => $lang));
        $this->return['delegates']          = Delegate::all_delegates(array('active' => 1,'lang' => $lang));
        $this->return['selected_models']    = ElevatorRModels::all_models(array('lang'=>$lang, 'ids'=>explode(',',$this->return['master']->models_id)));
        $this->return['elevator_payments']  = ElevatorPayments::all_payments(['lang'=>$lang,'active'=>1]);
        $this->return['link_token']         = $this->encryptRouteParameter($encrypted_data);
        $this->return['types']              = ElevatorTypes::get_type_lookup($lang);
        $this->return['citys']              = DB::table('citys')->selectRaw('city_id,name_'.$lang.' as name')->get();
        $this->return['taxes']              = Tax::all_taxes(['lang' => $lang , 'active' => 1 ]);

        return $this->sendResponse($this->return);
    }
    public function encryptRouteParameter($data)
    {
        $encryptedData = Crypt::encrypt($data);
        return $encryptedData;
    }
    public function decryptRouteParameter($encryptedData)
    {

        $decryptedData = Crypt::decrypt($encryptedData);
        return $decryptedData;

    }
    public function show_link($lang, $encryptedParameter,Request $request)
    {
        $decryptedData = $this->decryptRouteParameter($encryptedParameter);
        $id = $decryptedData['id'];

        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('12-002', $lang)->sub_title ?? '';
        $this->return['master']         = ElevatorsQuotation::get_quotation($id, $lang);
        if($this->return['master']->client_response > 1 ){
            return $this->sendError(trans('error.expired_link'));
        }
        $this->return['details']        = ElevatorsQuotation::get_quotation_payments(array('quotation_id' => $id,'lang'=>$lang));
        $this->return['attachments']    = DB::table('quotations_attachments')->where('quotation_id',$id)->get();
        $this->return['models']         = ElevatorModels::get_model_lookup($lang);
        $this->return['selected_models']= ElevatorRModels::all_models(array('lang'=>$lang, 'ids'=>explode(',',$this->return['master']->models_id)));
        $this->return['types']          = ElevatorTypes::get_type_lookup($lang);
        $this->return['branch_data']    = Branch::get_branch(1);
        $this->return['logo']           = get_logo(1);

        return $this->sendResponse($this->return);
    }

    public function update($lang, $id, Request $request)
    {
        $this->checkPermission('12-002','edit');
        $item = ElevatorsQuotation::get_quotation($id, $lang);
        if($item->paid_count > 0){
            return $this->sendError(trans('error.cannot edit'));
        }

        $inputs = $request->all();

        $master_seed = [
            'date'                  => $inputs['date'] ?? date('Y-m-d'),
            'description'           => $inputs['description'] ?? null,
            'book_contract_number'  => $inputs['book_contract_number'] ?? null,
            'customer_id'           => $inputs['customer_id'] ?? 0,
            'sales_agent_id'        => $inputs['sales_agent_id'] ?? 0,
            'delegate_id'           => $inputs['delegate_id'] ?? 0,
            'type_id'               => $inputs['type_id'] ?? 1,
            'city_id'               => $inputs['city_id'] ?? 0,
            'tax_id'                => $inputs['tax_id'] ?? 0,
            'warranty'              => $inputs['warranty'] ?? null,
            'elevators_count'       => $inputs['elevators_count'] ?? 1,
            'floors_count'          => $inputs['floors_count'] ?? 0,
            'add_user'              => auth()->user()->id
        ];

        if($master_seed['tax_id'] > 0 ){
            $master_seed['tax_percentage']      = DB::table('taxes')->where('tax_id',$master_seed['tax_id'])->value('tax_percentage');
            $master_seed['price_without_vat']   = ($inputs['price_with_vat'] / (1+ intval($master_seed['tax_percentage'])/100));
            $master_seed['price_with_vat']      = $inputs['price_with_vat'];

        }else{
            $master_seed['tax_percentage']      = 0;
            $master_seed['price_with_vat']      = $inputs['price_with_vat'];
            $master_seed['price_without_vat']   = $inputs['price_with_vat'];

        }
        $validator = validator()->make($master_seed, ElevatorsQuotation::$master_rules);

        if($validator->fails()){
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }
        $quotation = ElevatorsQuotation::get_quotation($id,$lang);
        DB::beginTransaction();
        if (isset($inputs['models']) && is_array($inputs['models'])){
            DB::table('elevators_r_models_m')->whereIn('elevators_r_models_m.model_m_id',explode(',',$quotation->models_id))->delete();
            DB::table('elevators_r_models_d')->whereIn('elevators_r_models_d.model_m_id',explode(',',$quotation->models_id))->delete();
            $models_id = [];
            foreach ($inputs['models'] as $item){
                $insert_master = [
                    'name_en'  => $item['name_en'],
                    'name_ar'  => $item['name_ar'],
                    'add_user' => auth()->user()->id
                ];

                $validator = validator()->make($insert_master, ElevatorRModels::$master_rules);

                if($validator->fails()){
                    return $this->sendError(trans('error.add_fails'), $validator->errors());
                }

                $model_m_id = ElevatorRModels::add_model_m($insert_master);

                if (isset($item['items']) && is_array($item['items'])){
                    foreach ($item['items'] as $detail){
                        $insert_details = array(
                            'model_m_id'        => $model_m_id,
                            'item_name'         => $detail['item_name'],
                            'description'       => $detail['description'],
                        );

                        $validator = validator()->make($insert_details, ElevatorRModels::$details_rules);

                        if($validator->fails()){
                            return $this->sendError(trans('error.add_fails'), $validator->errors());
                        }
                        ElevatorRModels::add_model_d($insert_details);
                    }
                }
                $models_id[] = $model_m_id;
            }
        }
        $master_seed['models_id'] = implode(',' , $models_id) ?? null ;
        ElevatorsQuotation::update_quotation($master_seed, $id);

        if (isset($inputs['payments']) && is_array($inputs['payments'])){
            DB::table('quotations_payments')->where('quotation_id',$id)->delete();
            foreach ($inputs['payments'] as $item) {
                DB::table('quotations_payments')->insert([
                        'quotation_id'        => $id,
                        'payment_name'        => $item['payment_name'] ?? null,
                        'percentage'          => $item['percentage'] ?? 0,
                        'details'             => $item['details'] ?? null,
                        'amount'              => $item['amount'] ?? 0,
                        'remaining'           => $item['amount'] ?? 0,
                    ]);
            }
        }
        DB::commit();
        return $this->sendResponse($id, trans('main.update_success'));
    }
    public function add_attachments($lang , $id ,Request $request)
    {
        $this->checkPermission('12-002','add');

        $input    = $request->all();

        $upload = (new Upload)->uploadFile($input['file_url'], 'quotations_attachments', $input['file_name']);
                if(!$upload)
                    return $this->sendError(trans("error.Something Error"));
                    $this->return['id'] = DB::table('quotations_attachments')->insert([
                    'quotation_id'      => $id,
                    'file_name'         => $upload['filename'],
                    'file_url'          => $upload['url'],
                    'add_user'          => auth()->user()->id,
                ]);

        return $this->sendResponse( $this->return , trans('main.add_success') );
    }
    public function delete_attachments($lang , $id)
    {
        $this->checkPermission('12-002','delete');

        $file_url = DB::table('quotations_attachments')->where('attachment_id',$id)->value('file_url');
        //delete the file from the storage
        if ($file_url && File::exists(public_path($file_url))) {
            File::delete(public_path($file_url));
        }
        ElevatorsQuotation::delete_attachments($id);
        return $this->sendResponse( $this->return , trans('main.delete_success') );
    }
    public function client_response($lang , $id, Request $request)
    {

        $item = ElevatorsQuotation::find($id);
        $inputs = $request->only('client_response');
        if($item->status == $inputs['client_response'] || !in_array($inputs['client_response'],[2,3])){
            return $this->sendError(trans('error.error_in_status'));
        }
        if($item->admin_response != 2){
            return $this->sendError(trans('error.admin_must_approved_first'));
        }
        $update = [
            'client_response'   => $inputs['client_response']//2=>approved,3=>rejected
        ];
        ElevatorsQuotation::update_quotation($update,$id);
        return $this->sendResponse( $this->return , trans('main.update_success') );
    }
    public function administrator_response($lang , $id, Request $request)
    {
        $this->checkPermission('12-002','edit');

            $item = ElevatorsQuotation::find($id);
            $encrypted_data = array('id'=>$id);
            $inputs = $request->only('admin_response');
            if($item->status == $inputs['admin_response'] || !in_array($inputs['admin_response'],[2,3])){
                return $this->sendError(trans('error.error_in_status'));
            }
            $update = [
                'admin_response' => $inputs['admin_response'], // 2 => approved, 3 =>rejected
            ];
            DB::beginTransaction();
            ElevatorsQuotation::update_quotation($update,$id);

            DB::commit();

        $this->return['link_token']     = $this->encryptRouteParameter($encrypted_data);

        return $this->sendResponse( $this->return , trans('main.update_success') );
    }
    public function convert_contract($lang , $id , Request $request)
    {
        $item = ElevatorsQuotation::find($id);

        if($item->admin_response != 2 && $item->client_response != 2){
            return $this->sendError(trans('error.admin_and_customer_must_approved_first'));
        }
        $update = [
            'is_contract'           => 1 ,
            'book_contract_number'  => $request['book_contract_number'] ?? 0,
            'invoice_code'          => ( DB::table('elevators_quotations')->where('is_contract' , 1 )->max('invoice_code') + 1 )
        ];
        ElevatorsQuotation::update_quotation($update,$id);
        return $this->sendResponse( $this->return , trans('main.update_success') );
    }
    public function get_all_payments($lang, Request $request)
    {
        $this->checkPermission('12-002','view');

        $this->filter = array(
            'lang'          => $lang,
            'rows'          => $request['rows'] ?? 20 ,
            'page'          => $request['page'] ?? 1 ,
            'customer_id'   => $request['customer_id'] ?? null,
            'customer_phone'=> $request['customer_phone'] ?? null,
            'status'        => $request['status'] ?? null,
            'quotation_id'  => $request['quotation_id'] ?? null,
            'invoice_code'  => $request['invoice_code'] ?? null,
            'from_date'     => $request['from_date'] ?? null,
            'to_date'       => $request['to_date'] ?? null,

        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('12-002', $lang)->sub_title ?? '';
        $this->return['items']       = ElevatorsQuotation::get_quotation_payments($this->filter);
        $this->return['customers']   = Customer::all_customers(array('active' => 1,'lang' => $lang));

        return $this->sendResponse($this->return);
    }
    public function start_payment_stage($lang, $id)
    {
        $this->checkPermission('12-002','view');
        $item = ElevatorsQuotation::get_quotation_payments(array('lang' => $lang, 'payment_id' => $id));
        if($item->payment_status < 1){
            return $this->sendError(trans('error.not_paid'));
        }
        DB::table('quotations_payments')->where('payment_id', $id)->update(array(
            'status'     => 2,
            'start_date' => date('Y-m-d'),
        ));

        return $this->sendResponse($this->return,trans('main.update_success'));
    }

    public function end_payment_stage($lang, $id)
    {
        $this->checkPermission('12-002','view');

        DB::table('quotations_payments')->where('payment_id', $id)->update(array(
            'status'   => 3,
            'end_date' => date('Y-m-d'),
        ));
        $quotation_id =        DB::table('quotations_payments')->where('payment_id', $id)->value('quotation_id');
        $not_ended_stages = DB::table('quotations_payments')->where([['status','!=',3],['quotation_id',$quotation_id]])->count();
        if($not_ended_stages == 0){
            DB::table('elevators_quotations')->where('quotation_id',$quotation_id)->update(array(
                'contract_status' => 2,
            ));
        }
        return $this->sendResponse($this->return,trans('main.update_success'));
    }
    public function payment_installment($lang, $id)
    {
        $this->checkPermission('12-002','view');

        $inputs  = request()->only('voucher_id');

        $voucher = DB::table('receipt_vouchers')->where('receipt_voucher_id',$inputs['voucher_id'])->first();
        $payment = ElevatorsQuotation::get_quotation_payments(array('lang' => $lang,'payment_id' => $id));

        $voucher_amount = $voucher->amount;
        $remaining_amount = 0;
        $payment_remaining = $payment->remaining;


            if($voucher_amount >= $payment_remaining ){
                $paid               = $payment_remaining;
                $remaining_amount   = $voucher_amount - $paid;
                DB::beginTransaction();

                DB::table('quotations_payments_installments')->insertGetId(array(
                    'amount'        => $paid,
                    'voucher_id'    => $voucher->receipt_voucher_id,
                    'payment_id'    => $id
                ));
                $other_payments = ElevatorsQuotation::get_quotation_payments(array('lang' => $lang,'quotation_id' => $payment->quotation_id));
                $other_payments = collect($other_payments)->where('remaining','>', 0)->toArray();
                    if($other_payments != null){
                        foreach($other_payments as $item){
                            if($remaining_amount > 0){
                                $amount_to_pay = min($remaining_amount, $item->remaining);
                                DB::table('quotations_payments_installments')->insertGetId(array(
                                    'amount'        => $amount_to_pay,
                                    'voucher_id'    => $voucher->receipt_voucher_id,
                                    'payment_id'    => $item->payment_id
                                ));
                                $remaining_amount -= $amount_to_pay;
                            }
                        }
                    }

                // DB::table('receipt_vouchers')->where('receipt_voucher_id',$inputs['voucher_id'])->update(array('auto_generated'=>1));

            DB::commit();
            }elseif($voucher_amount < $payment_remaining){
                $paid               = $voucher_amount;
                DB::table('quotations_payments_installments')->insertGetId(array(
                    'amount'        => $voucher_amount,
                    'voucher_id'    => $voucher->receipt_voucher_id,
                    'payment_id'    => $id
                ));
            }

        return $this->sendResponse($this->return,trans('main.update_success'));
    }

    public function destroy($lang, $id)
    {
        $this->checkPermission('12-002','delete');

        ElevatorsQuotation::delete_quotation($id);

        return $this->sendResponse([], trans('main.delete_success'));
    }

    public function toggle_active($lang, $id)
    {
        $item = ElevatorsQuotation::find($id);

        if($item->active){
            $this->checkPermission('12-002','view');

            ElevatorsQuotation::delete_quotation($id);
            $this->return['active'] = false;
        }else{
            $this->checkPermission('12-002','view');

            ElevatorsQuotation::update_quotation(array('active' => 1), $id);
            $this->return['active'] = true;
        }

        return $this->sendResponse($this->return, trans('main.update_success'));
    }
}
