<?php

namespace App\Http\Controllers\API\V1\Finance;
use App\Http\Controllers\API\V1\BaseController;

use App\Classes\Finance\ChequeOutgoingHelper;


use App\Models\Finance\ChequeOutgoing;
use App\Models\Main\ScreenSub;
use Illuminate\Http\Request;


class ChequeOutgoingController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang , Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['02-011'][0]->permission) ){
            return $this->sendError( 'view permission needed #02-011' , $this->data , 200 );
        }
        $this->filter = array(
            'lang'          => $lang ,
            'active'        => $request['active'] ?? 1 ,
            'rows'          => $request['rows'] ?? 20 ,
            'page'          => $request['page'] ?? 1 ,
            'word'          => $request['word'] ?? null ,
            'status'        => $request['status'] ?? null ,
            'from_date'     => $request['from_date'] ?? null ,
            'to_date'       => $request['to_date'] ?? null ,
            'branch'        => $this->data['current_branch'] ,
            'finance_year'  => $this->data['current_year']
        );
        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('02-011' , $lang)->sub_title ?? '';
        $this->return['items']       = ChequeOutgoing::all_cheque_outgoing( $this->filter );
        return $this->sendResponse( $this->return );
    }

    public function changeChequeStatus($lang , $id, Request $request)
    {
        if(!@in_array('3', $this->data['mypermissions']['02-011'][0]->permission) ){
            return $this->sendError( 'update permission needed #02-011' , [] , 200 );
        }

        if( !(new ChequeOutgoingHelper)->can_edit_or_delete($id) ){
            return $this->sendError( "Can't edit or delete this action" , [] , 200 );
        }

        $update = [
            'cheque_status_id' => $request['status'] ?? 0
        ];
        switch ($update['cheque_status_id'] ?? 0 ) {
            case '1':
                $update['collect_date'] = date("Y-m-d H:i:s") ;
                $update['collect_user'] = auth()->user()->id ;
            break;
            case '2':
                $update['reject_date'] = date("Y-m-d H:i:s") ;
                $update['reject_user'] = auth()->user()->id ;
            break;
            case '3':
                $update['deposit_date'] = date("Y-m-d H:i:s") ;
                $update['deposit_user'] = auth()->user()->id ;
            break;
        }

        ChequeOutgoing::update_cheque_outgoing($update , $id);

        return $this->sendResponse( $this->return , trans('main.update_success') );
    }
}
