<?php

namespace App\Http\Controllers\API\V1\FinancialStatements;

use App\Http\Controllers\API\V1\BaseController;
use Illuminate\Http\Request;
use App\Models\Main\ScreenSub;
use App\Models\FinancialStatements\FinancialCollections;
use App\Models\Finance\AccountTree;

use Illuminate\Validation\Rule;

class FinancialCollectionsController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang , Request $request)
    {
        $this->checkPermission('02-017','view');

        $this->filter = array(
            'lang'        => $lang ,
            'rows'        => $request['rows'] ?? null ,
            'page'        => $request['page'] ?? 1 ,
            'word'        => $request['word'] ?? null
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('02-017' , $lang)->sub_title ?? '';
        $this->return['items']       = FinancialCollections::all_financial_collections($this->filter);
        return $this->sendResponse($this->return );
    }

    public function create($lang , Request $request)
    {
        $this->checkPermission('02-017','add');

        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('02-017' , $lang)->sub_title ?? '';
        $this->return['account_trees']  = AccountTree::active_account_trees($lang, array('active' => '1'));
        return $this->sendResponse( $this->return);
    }

    public function store(Request $request)
    {
        $this->checkPermission('02-017','add');

        $input    = $request->all();
        $insert = [
            'name_ar'           => $input['name_ar'] ,
            'name_en'           => $input['name_en'] ,
            'statement_id'      => $input['statement_id'],
            'type'              => $input['type'] ?? 1,
            'parent_id'         => $input['parent_id'] ?? 0,
            'account_id'        => $input['account_id'] ?? 0,
            'factor'            => $input['factor'],
            'is_print'          => $input['is_print'] ?? 0,
            'balance_type'      => $input['balance_type'] ?? 3 ,
            'add_user'          => auth()->user()->id,
        ];

        $validator = validator()->make( $insert , FinancialCollections::$rules );
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }

        $this->return['id'] = FinancialCollections::add_financial_collection($insert);

        return $this->sendResponse( $this->return , trans('main.add_success') );
    }

    public function show($lang , $id )
    {
        $this->checkPermission('02-017','view');

        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('02-017' , $lang)->sub_title ?? '';
        $this->return['item']           = FinancialCollections::get_financial_collection($id,$lang);
        return $this->sendResponse( $this->return);
    }

    public function update($lang, $id , Request $request)
    {
        $this->checkPermission('02-017','edit');

        $input  = $request->all();

        $update = [
            'name_ar'           => $input['name_ar'] ,
            'name_en'           => $input['name_en'] ,
            'type'              => $input['type'] ,
            'statement_id'      => $input['statement_id'],
            'parent_id'         => $input['parent_id'],
            'account_id'        => $input['account_id'] ?? 0,
            'factor'            => $input['factor'],
            'is_print'          => $input['is_print'],
            'balance_type'      => $input['balance_type'] ?? 3 ,
        ];
        $update_rules = [
            'name_en' => [
                'required',
                'string',
                Rule::unique('financial_collections')->ignore($id,'collection_id'),
            ],
            'name_ar' => [
                'required',
                'string',
                Rule::unique('financial_collections')->ignore($id,'collection_id'),
            ],
        ];
        $validator  = validator()->make( $update , $update_rules);
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }
        FinancialCollections::update_financial_collection($update ,$id );
        $this->return = FinancialCollections::get_financial_collection($id,$lang);

        return $this->sendResponse( $this->return , trans('main.update_success') );
    }
    public function destroy($lang,$id)
    {
        $this->checkPermission('02-017','delete');

        FinancialCollections::delete_financial_collection($id);

        return $this->sendResponse( [] , trans('main.delete_success') );
    }




}
