<?php

namespace App\Http\Controllers\API\V1\Inventory;
use App\Classes\Inventory\StockTransferHelper;
use App\Classes\ItemStock;
use App\Http\Controllers\API\V1\BaseController;
use App\Models\Inventory\Item;
use App\Models\Inventory\StockTransfer;
use App\Models\Inventory\UnitMeasurement;
use App\Models\Inventory\Warehouse;
use App\Models\Main\ScreenSub;
use Illuminate\Http\Request;
use DB;

class StockTransferController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang, Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['03-008'][0]->permission)){
            return $this->sendError('view permission needed #03-008', $this->data, 200);
        }

        $this->filter = array(
            'lang'          => $lang ,
            'active'        => $request['active'] ?? 1 ,
            'rows'          => $request['rows'] ?? 20 ,
            'page'          => $request['page'] ?? 1 ,
            'word'          => $request['word'] ?? null ,
            'branch'        => $this->data['current_branch'] ,
            'finance_year'  => $this->data['current_year']
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('03-008', $lang)->sub_title ?? '';
        $this->return['items']       = StockTransfer::all_stock_transfers($this->filter);

        return $this->sendResponse( $this->return );
    }

    public function create($lang, Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['03-008'][0]->permission)){
            return $this->sendError('create permission needed #03-008', [], 200);
        }

        $this->return['screen_name']       = ScreenSub::get_screen_sub_by_screen_code('03-008', $lang)->sub_title ?? '';
        $this->return['warehouses']        = Warehouse::all_warehouses(array('active' => 1, 'lang' => $lang));
        $this->return['items']             = Item::all_items(array('active' => 1, 'lang' => $lang));
        $this->return['unit_measurements'] = UnitMeasurement::all_unit_measurements(array('active' => 1, 'lang' => $lang));

        return $this->sendResponse($this->return);
    }

    public function store($lang, Request $request)
    { 
        if(!@in_array('2', $this->data['mypermissions']['03-008'][0]->permission)){
            return $this->sendError('create permission needed #03-008', [], 200);
        }

        $insert = $request->only(['stock_transfer_date', 'stock_transfer_description', 'items']);

        $year   = array_search(date("Y", strtotime($insert['stock_transfer_date'])), $this->data['years']);

        if($year == ''){
            return $this->sendError(trans("error.finance_year_not_aval"));
        }

        $codes = (new StockTransferHelper)->get_next_codes($insert['stock_transfer_date'], $year, $this->data['current_branch']);

        $master_seed = [
            'branch_id'                  => $this->data['current_branch'],
            'finance_year_id'            => $year,
            'year_ser'                   => $codes['year_ser'],
            'month_ser'                  => $codes['month_ser'],
            'branch_ser'                 => $codes['branch_ser'],
            'daily_journal_m_id'         => 0,
            'stock_transfer_date'        => $insert['stock_transfer_date'],
            'stock_transfer_description' => $insert['stock_transfer_description'],
            'add_user'                   => auth()->user()->id
        ];

        $validator = validator()->make($master_seed, StockTransfer::$master_rules);

        if($validator->fails())
        {
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }

        DB::beginTransaction();

        $m_id = StockTransfer::add_stock_transfer_m($master_seed);
        $source_from = ItemStock::transfer_from_source;
        $source_to = ItemStock::transfer_to_source;
        if (isset($insert['items']) && is_array($insert['items'])){
            foreach ($insert['items'] as $item){
                if (isset($item['unit_id']) && !is_null($item['unit_id'])){
                    $selectedItem = DB::table('items')->where('item_id', $item['item_id'])->first();
                    if ($item['unit_id'] == $selectedItem->big_unit_id){
                        $item['unit_type'] = 3;
                    }elseif ($item['unit_id'] == $selectedItem->mid_unit_id){
                        $item['unit_type'] = 2;
                    }elseif ($item['unit_id'] == $selectedItem->small_unit_id){
                        $item['unit_type'] = 1;
                    }else{
                        $item['unit_type'] = 3;
                    }
                }
                $details_seed = array(
                    'stock_transfer_m_id' => $m_id,
                    'from_warehouse_id'   => $item['from_warehouse_id'],
                    'to_warehouse_id'     => $item['to_warehouse_id'],
                    'item_id'             => $item['item_id'],
                    'unit_id'             => $item['unit_id'],
                    'unit_type'           => $item['unit_type'] ?? 0,
                    'quantity'            => $item['quantity'] ?? 0,
                    'price'               => $item['price'] ?? 0,
                    'total_price'         => ($item['price'] * $item['quantity']),
                    'add_user'            => auth()->user()->id
                );

                $validator = validator()->make($details_seed, StockTransfer::$details_rules);

                if($validator->fails())
                {
                    return $this->sendError(trans('error.add_fails'), $validator->errors());
                }

                $d_id = StockTransfer::add_stock_transfer_d($details_seed);

                // Item Stock
                // Reduction Quantity From (From_Warehouse_ID)
                (new ItemStock)->update_item_stock($this->data['current_branch'], $item['item_id'], $item['from_warehouse_id'], $source_from, $m_id, $d_id, $item['quantity'], 0 , $item['unit_id'], $item['unit_type'], 0);
                // Increasing Quantity In (To_Warehouse_ID)
                (new ItemStock)->update_item_stock($this->data['current_branch'], $item['item_id'], $item['to_warehouse_id'], $source_to, $m_id, $d_id, $item['quantity'], 0 , $item['unit_id'], $item['unit_type'], 0);
            }
        }

        $updateMasterValues   = (new StockTransferHelper)->update_master_values($m_id);
        $generateDailyJournal = (new StockTransferHelper)->generate_daily_journal($m_id);

        DB::commit();
        return $this->sendResponse([], trans('main.add_success'));
    }

    public function show($lang, $id)
    {
        if(!@in_array('1', $this->data['mypermissions']['03-008'][0]->permission)){
            return $this->sendError('show permission needed #03-008', [], 200);
        }

        $this->return['screen_name']       = ScreenSub::get_screen_sub_by_screen_code('03-008' , $lang)->sub_title ?? '';
        $this->return['master']            = StockTransfer::get_stock_transfer_m($id, $lang);
        $this->return['details']           = StockTransfer::get_stock_transfer_d($id, $lang);

        $this->return['warehouses']        = Warehouse::all_warehouses(array('active' => 1, 'lang' => $lang));
        $this->return['items']             = Item::all_items(array('active' => 1, 'lang' => $lang));
        $this->return['unit_measurements'] = UnitMeasurement::all_unit_measurements(array('active' => 1, 'lang' => $lang));

        return $this->sendResponse($this->return, trans('main.add_success'));
    }

    public function update($lang, $id, Request $request)
    {
        if(!@in_array('3', $this->data['mypermissions']['03-008'][0]->permission)){
            return $this->sendError( 'update permission needed #03-008', [], 200);
        }

        $update = $request->only(['stock_transfer_date', 'stock_transfer_description']);

        StockTransfer::update_stock_transfer_m($update, $id);
        return $this->sendResponse($this->return, trans('main.update_success'));
    }

//    public function update($lang, $id, Request $request)
//    {
//        if(!@in_array('3', $this->data['mypermissions']['03-008'][0]->permission)){
//            return $this->sendError('update permission needed #03-008', [], 200);
//        }
//
//        $update = $request->only(['stock_transfer_date', 'stock_transfer_description', 'items']);
//
//        if(!isset($update['items']) || !is_array($update['items'])){
//            return $this->sendError(trans("error.items"));
//        }
//
//        $master = StockTransfer::get_stock_transfer_m($id);
//
//        if(!isset($master->stock_transfer_m_id) || $master->branch_id != $this->data['current_branch'] || !(new StockTransferHelper)->can_edit_or_delete($id)){
//            return $this->sendError( trans("error.update_fail")  );
//        }
//
//        $update_seed = collect($update)->only('stock_transfer_date', 'stock_transfer_description')->all() ;
//        $rules       = collect(StockTransfer::$master_rules)->only('stock_transfer_date', 'stock_transfer_description')->all();
//
//        $validator = validator()->make($update_seed, $rules);
//
//        if($validator->fails())
//        {
//            return $this->sendError(trans('error.update_fails'), $validator->errors());
//        }
//
//        DB::beginTransaction();
//
//        StockTransfer::update_stock_transfer_m($update_seed, $id);
//        StockTransfer::delete_stock_transfer_d($id);
//
//        if (isset($update['items']) && is_array($update['items'])) {
//            foreach ($update['items'] as $item){
//                if (isset($item['unit_id']) && !is_null($item['unit_id'])){
//                    $selectedItem = DB::table('items')->where('item_id', $item['item_id'])->first();
//                    if ($item['unit_id'] == $selectedItem->big_unit_id){
//                        $item['unit_type'] = 3;
//                    }elseif ($item['unit_id'] == $selectedItem->mid_unit_id){
//                        $item['unit_type'] = 2;
//                    }elseif ($item['unit_id'] == $selectedItem->small_unit_id){
//                        $item['unit_type'] = 1;
//                    }
//                }
//                $details_seed = array(
//                    'stock_transfer_m_id' => $id,
//                    'from_warehouse_id'   => $item['from_warehouse_id'],
//                    'to_warehouse_id'     => $item['to_warehouse_id'],
//                    'item_id'             => $item['item_id'],
//                    'unit_id'             => $item['unit_id'],
//                    'unit_type'           => $item['unit_type'] ?? 0,
//                    'quantity'            => $item['quantity'] ?? 0,
//                    'price'               => $item['price'] ?? 0,
//                    'total_price'         => ($item['price'] * $item['quantity']),
//                    'add_user'            => auth()->user()->id
//                );
//
//                $validator = validator()->make($details_seed, StockTransfer::$details_rules);
//
//                if($validator->fails())
//                {
//                    return $this->sendError(trans('error.update_fails'), $validator->errors());
//                }
//
//                StockTransfer::add_stock_transfer_d($details_seed);
//            }
//        }
//
//        $updateMasterValues   = (new StockTransferHelper)->update_master_values($id);
//        $generateDailyJournal = (new StockTransferHelper)->generate_daily_journal($id);
//
//        DB::commit();
//        return $this->sendResponse($this->return, trans('main.update_success'));
//    }

    public function destroy($lang, $id)
    {
        if(!@in_array('4', $this->data['mypermissions']['03-008'][0]->permission)){
            return $this->sendError( 'delete permission needed #03-008', [], 200);
        }

        $master = StockTransfer::get_stock_transfer_m($id);

        if(!isset($master->stock_transfer_m_id) || $master->branch_id != $this->data['current_branch'] || !(new StockTransferHelper)->can_edit_or_delete($id)){
            return $this->sendError(trans("error.delete_fail"));
        }

        StockTransfer::delete_stock_transfer_m($id);

        return $this->sendResponse([], trans('main.delete_success'));
    }

    public function toggle_active($lang, $id)
    {
        $item = StockTransfer::find($id);

        if($item->stock_transfer_active){
            if(!@in_array('4', $this->data['mypermissions']['03-008'][0]->permission)){
                return $this->sendError('update permission needed #03-008', [], 200);
            }

            if(!(new StockTransferHelper)->can_edit_or_delete($id)){
                return $this->sendError( trans('error.delete_fails'), []);
            }

            StockTransfer::delete_stock_transfer_m($id);
            $this->return['active'] = false;
        }else{
            if(!@in_array('3', $this->data['mypermissions']['03-008'][0]->permission)){
                return $this->sendError( 'update permission needed #03-008', [], 200);
            }

            if(!(new StockTransferHelper)->can_edit_or_delete($id)){
                return $this->sendError( trans('error.update_fails'), []);
            }

            StockTransfer::update_stock_transfer_m(array('stock_transfer_active' => 1), $id);
            $this->return['active'] = true;
        }

        return $this->sendResponse($this->return, trans('main.update_success'));
    }

    public function get_from_warehouse_stock_items($lang, Request $request)
    {
        $stock_items_ids = DB::table('stocks')
            ->where('warehouse_id', $request['from_warehouse_id'])
            ->where('stock', '>', 0)
            ->pluck('item_id');

        $this->return['items'] = Item::all_items(array('active' => 1, 'lang' => $lang, 'stock_items_ids' => $stock_items_ids));
        return $this->sendResponse($this->return, trans('main.Data Retrieved'));
    }
}
