<?php

namespace App\Http\Controllers\API\V1\Main;
use App\Http\Controllers\API\V1\BaseController;
use Illuminate\Http\Request;

use App\Models\Finance\AccountTree;
use App\Models\Main\Bank;
use App\Models\Main\ScreenSub;
use App\Models\Main\SalesAgent;



class BankController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang , Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['01-010'][0]->permission) ){
            return $this->sendError( 'view permission needed #01-010' , $this->data , 200 );
        }

        $this->filter = array(
            'lang'        => $lang ,
            'active'      => $request['active'] ?? 1 ,
            'rows'        => $request['rows'] ?? null ,
            'page'        => $request['page'] ?? 1 ,
            'word'        => $request['word'] ?? null
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('01-010' , $lang)->sub_title ?? '';
        $this->return['items']       = Bank::all_banks( $this->filter );

        return $this->sendResponse( $this->return );
    }

    public function create($lang , Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['01-010'][0]->permission) ){
            return $this->sendError( 'create permission needed #01-010' , [] , 200 );
        }

        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('01-010' , $lang)->sub_title ?? '';
        $this->return['account_tree']   = AccountTree::active_account_trees($lang , array('account_type' => 2 , 'active' => 1 ));

        return $this->sendResponse( $this->return  );
    }

    public function store($lang , Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['01-010'][0]->permission) ){
            return $this->sendError( 'create permission needed #01-010' , [] , 200 );
        }
        $insert    = $request->only(['name_en', 'name_ar', 'account_tree_id', 'mastercard', 'visa', 'mada']);
        $validator = validator()->make( $insert , Bank::$rules );
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }
        $insert['add_user'] = auth()->user()->id;
        $this->return['id'] = Bank::add_bank($insert);

        return $this->sendResponse( $this->return , trans('main.add_success') );
    }

    public function show($lang , $id , Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['01-010'][0]->permission) ){
            return $this->sendError( 'show permission needed #01-010' , [] , 200 );
        }

        $this->return['screen_name']        = ScreenSub::get_screen_sub_by_screen_code('01-010' , $lang)->sub_title ?? '';
        $this->return['data']               = Bank::find($id);
        $this->return['account_tree']       = AccountTree::active_account_trees($lang , array('account_type' => 2 , 'active' => 1 ));

        return $this->sendResponse( $this->return , '' );
    }

    public function update($lang , $id , Request $request)
    {
        if(!@in_array('3', $this->data['mypermissions']['01-010'][0]->permission) ){
            return $this->sendError( 'update permission needed #01-010' , [] , 200 );
        }

        $update     = $request->only(['name_en', 'name_ar', 'account_tree_id', 'mastercard', 'visa', 'mada']);
        $validator  = validator()->make( $update , Bank::$rules );
        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails') , $validator->errors() );
        }
        Bank::update_bank($update ,  $id );
        return $this->sendResponse( $this->return , trans('main.update_success') );
    }

    public function destroy($lang , $id)
    {
        if(!@in_array('4', $this->data['mypermissions']['01-010'][0]->permission) ){
            return $this->sendError( 'delete permission needed #01-010' , [] , 200 );
        }

        Bank::delete_bank($id);

        return $this->sendResponse( [] , trans('main.delete_success') );
    }

    public function sort_post($lang , Request $request){
        if(!@in_array('3', $this->data['mypermissions']['01-010'][0]->permission) ){
            return $this->sendError( 'update permission needed #01-010' , [] , 200 );
        }

        $sort = $request->all();
        foreach ($sort['items'] as $key => $value) {
            Bank::update_bank(array('bank_order' => $key ),  $value['id']);
        }
        return $this->sendResponse( [] , trans('main.update_success') );

    }

    public function toggle_active($lang , $id){
        $item = Bank::find($id);
        if($item->bank_active){

            if(!@in_array('4', $this->data['mypermissions']['01-010'][0]->permission) ){
                return $this->sendError( 'update permission needed #01-010' , [] , 200 );
            }

            Bank::delete_bank($id);
            $this->return['active'] = false;

        }else{

            if(!@in_array('3', $this->data['mypermissions']['01-010'][0]->permission) ){
                return $this->sendError( 'update permission needed #01-010' , [] , 200 );
            }

            Bank::update_bank(array('bank_active' => 1 ) , $id);
            $this->return['active'] = true;
        }
        return $this->sendResponse( $this->return , trans('main.update_success') );
    }

}
