<?php

namespace App\Http\Controllers\API\V1\Main;
use App\Http\Controllers\API\V1\BaseController;
use App\Models\Main\ScreenSub;
use App\Models\Main\Title;
use App\Models\User;
use Illuminate\Http\Request;
use DB;

class TitleController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang, Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['01-016'][0]->permission)){
            return $this->sendError('view permission needed #01-016', $this->data, 200);
        }

        $this->filter = array(
            'lang'   => $lang ,
            'active' => $request['active'] ?? 1 ,
            'rows'   => $request['rows'] ?? null ,
            'page'   => $request['page'] ?? 1 ,
            'word'   => $request['word'] ?? null ,
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('01-016', $lang)->sub_title ?? '';
        $this->return['items']       = Title::all_titles($this->filter);

        return $this->sendResponse($this->return);
    }

    public function create($lang, Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['01-016'][0]->permission)){
            return $this->sendError('view permission needed #01-016', $this->data, 200);
        }

        $this->return['screen_name']     = ScreenSub::get_screen_sub_by_screen_code('01-016', $lang)->sub_title ?? '';
        $this->return['all_permissions'] = ScreenSub::all_screen_subs(array('lang' => $lang));

        return $this->sendResponse($this->return);
    }

    public function store($lang, Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['01-016'][0]->permission)){
            return $this->sendError('view permission needed #01-016', $this->data, 200);
        }

        $insert    = $request->only(['title_name_en', 'title_name_ar']);

        $validator = validator()->make($insert, Title::$rules);

        if($validator->fails())
        {
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }

        $insert['add_user'] = auth()->user()->id;

        DB::beginTransaction();
        $this->return['id'] = Title::add_title($insert);

        if (isset($request['permissions']) && is_array($request['permissions'])){
            foreach ($request['permissions'] as $value) {
                if(!is_array($value['title_permission'])){
                    $value['title_permission'] = explode(',', $value['title_permission']);
                }

                DB::table('title_permissions')->insert([
                    'title_id'      => $this->return['id'] ,
                    'screen_sub_id' => $value['sub_id'] ,
                    'permission'    => json_encode($value['title_permission']),
                    'add_user'      => auth()->user()->id ,
                    'add_date'      => date("Y-m-d H:i:s")
                ]);
            }
        }

        DB::commit();
        return $this->sendResponse($this->return, trans('main.add_success'));
    }

    public function show($lang, $id)
    {
        if(!@in_array('1', $this->data['mypermissions']['01-016'][0]->permission)){
            return $this->sendError('view permission needed #01-016', $this->data, 200);
        }

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('01-016', $lang)->sub_title ?? '';
        $this->return['data']        = Title::get_title($id, $lang);
        $this->return['all_permissions'] = ScreenSub::all_screen_subs(array('lang' => $lang));

        $title_permissions               = Title::get_title_permission($id, null, true)->groupBy('screen_code')->toArray();

        foreach ($this->return['all_permissions'] as $key => $value) {
            $screens        = array('1' => 'view', '2' => 'add', '3' => 'edit', '4' => 'delete', '5' => 'print');
            $actions        = explode(',', $value->actions);
            $permissions    = json_decode($title_permissions[$value->screen_code][0]->permission ?? "[]");
            $sync           = array();

            foreach($actions as $action_key => $row){
                if(in_array($row, $permissions)){
                    $sync[$screens[$row]] = true;
                }else{
                    $sync[$screens[$row]] = false;
                }
            }

            $this->return['all_permissions'][$key]->permissions = $sync;
        }

        $data['permissions'] = Title::get_title_permission($id, $lang, null, null);

        foreach ($data['permissions'] as $key => $value) {
            $data['permissions'][$key]->permission = json_decode($value->permission);
        }

        $this->return['title_permissions'] = collect($data['permissions'])->groupBy('screen_code')->toArray();

        return $this->sendResponse($this->return);
    }

    public function update($lang, $id, Request $request)
    {
        if(!@in_array('3', $this->data['mypermissions']['01-016'][0]->permission)){
            return $this->sendError('view permission needed #01-016', $this->data, 200);
        }

        $update    = $request->only(['title_name_en', 'title_name_ar']);

        $validator = validator()->make($update, Title::$rules);

        if($validator->fails())
        {
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }

        DB::beginTransaction();

        if (isset($request['permissions']) && is_array($request['permissions'])){
            foreach ($request['permissions'] as $value) {
                if(!is_array($value['title_permission'])){
                    $value['title_permission'] = explode(',', $value['title_permission']);
                }

                DB::table('title_permissions')
                    ->where('title_id', $id)
                    ->where('screen_sub_id', $value['sub_id'])
                    ->delete();

                DB::table('title_permissions')->insert([
                    'title_id'      => $id ,
                    'screen_sub_id' => $value['sub_id'] ,
                    'permission'    => json_encode($value['title_permission']),
                    'add_user'      => auth()->user()->id ,
                    'add_date'      => date("Y-m-d H:i:s")
                ]);
            }
        }

        Title::update_title($update, $id);

        $users = DB::table('user_permissions')
            ->where('title_id' , $id)
            ->groupBy('user_id')
            ->get();
            
        $permissions    = DB::table('title_permissions')->where('title_id' , $id)->get();

        foreach ($users as $key => $user) {

            User::clear_permission($user->user_id);
            foreach ($permissions as $row) 
            {
                User::insert_user_permission(array('screen_sub_id'  => $row->screen_sub_id ,
                                                   'title_id'       => $id ,
                                                   'user_id'        => $user->user_id ,
                                                   'permission'     => $row->permission , 
                                                   'add_user'       => auth()->user()->id ,
                                                   'add_date'       => date("Y-m-d H:i:s") ));
            }

        }

        DB::commit();
        return $this->sendResponse($this->return, trans('main.update_success'));
    }

    public function destroy($lang, $id)
    {
        if(!@in_array('4', $this->data['mypermissions']['01-016'][0]->permission)){
            return $this->sendError('view permission needed #01-016', $this->data, 200);
        }

        Title::delete_title($id);
        return $this->sendResponse([], trans('main.delete_success'));
    }

    public function toggle_active($lang, $id)
    {
        $item = Title::find($id);

        if($item->title_active){
            if(!@in_array('4', $this->data['mypermissions']['01-016'][0]->permission)){
                return $this->sendError('view permission needed #01-016', $this->data, 200);
            }

            Title::delete_title($id);
            $this->return['active'] = false;
        }else{
            if(!@in_array('3', $this->data['mypermissions']['01-016'][0]->permission)){
                return $this->sendError('view permission needed #01-016', $this->data, 200);
            }

            Title::update_title(array('title_active' => 1), $id);
            $this->return['active'] = true;
        }

        return $this->sendResponse($this->return, trans('main.update_success'));
    }
}
