<?php

namespace App\Http\Controllers\API\V1\POS;

use App\Classes\Excel\InvoicesExport;
use App\Http\Controllers\API\V1\BaseController;
use App\Models\Finance\ExpenseCode;
use Illuminate\Http\Request;
use App\Classes\Finance\PaymentVoucherHelper;
use App\Models\Finance\PaymentVoucher;
use App\Models\Main\ScreenSub;
use App\Models\Main\Setting;
use App\Models\Main\Branch;

use DB;
use App;
use PDF;

class ExpenseController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang, Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['06-009'][0]->permission)){
            return $this->sendError('view permission needed #06-009', $this->data, 200);
        }

        $this->filter = array(
            'lang'      => $lang ,
            'active'    => $request['active'] ?? 1 ,
            'rows'      => $request['rows'] ?? 20 ,
            'page'      => $request['page'] ?? 1 ,
            'word'      => $request['word'] ?? null ,
            'from_date' => $request['from_date'] ?? null ,
            'to_date'   => $request['to_date'] ?? null ,
            'branch'    => $this->data['current_branch']
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('06-009', $lang)->sub_title ?? '';
        $this->return['items']       = PaymentVoucher::all_payment_voucher($this->filter);

        return $this->sendResponse($this->return);
    }

    public function create($lang, Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['06-009'][0]->permission)){
            return $this->sendError('create permission needed #06-009', [], 200);
        }

        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('06-009', $lang)->sub_title ?? '';
        $this->return['expenses_codes'] = ExpenseCode::all_expense_codes(array('lang' => $lang, 'active' => 1));

        return $this->sendResponse($this->return);
    }

    public function store($lang, Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['06-009'][0]->permission)){
            return $this->sendError('create permission needed #06-009', [], 200);
        }

        $branch_id = $this->data['shift']->branch_id ?? 0;

        if($branch_id == 0){
            return $this->sendError('Shift is not started', [], 401);
        }

        $insert = $request->only(['expense_code_id', 'action_date', 'description', 'amount', 'pay_for']);

        $year   = array_search(date("Y", strtotime($insert['action_date'])), $this->data['years']);

        if($year == ''){
            return $this->sendError(trans("error.finance_year_not_aval"));
        }

        $codes = (new PaymentVoucherHelper)->get_next_codes($insert['action_date'], $year, $this->data['current_branch']);

        $expense_code = DB::table('expense_codes')->where('expense_code_id', $insert['expense_code_id'])->first();

        $insert_seed = array(
            'finance_year_id'      => $year,
            'branch_id'            => $this->data['current_branch'],
            'description'          => $insert['description'],
            'year_ser'             => $codes['year_ser'],
            'month_ser'            => $codes['month_ser'],
            'branch_ser'           => $codes['branch_ser'],
            'action_date'          => $insert['action_date'],
            'cost_center_id'       => $expense_code->cost_center_id ?? 0,
            'amount'               => $insert['amount'] ?? 0,
            'invoice_type'         => 2,
            'delegate_id'          => 0,
            'document_number'      => $insert['document_number'] ?? '',
            'pay_for'              => $insert['pay_for'] ?? '',
            'expense_code_id'      => $insert['expense_code_id'] ?? 0,

            'to_type'              => 1,
            'to_account_tree_id'   => $expense_code->account_tree_id ?? 0,
            'to_supplier_id'       => 0,
            'to_customer_id'       => 0,

            'from_type'            => 2,
            'from_account_tree_id' => 0,
            'from_treasury_id'     => 1,
            'from_bank_id'         => 0,
            'due_date'             => 0,
            'cheque_number'        => 0,
            'shift_id'             => $this->data['shift']->shift_id,
            'add_user'             => auth()->user()->id
        );


        $validator = validator()->make($insert_seed, PaymentVoucher::$rules);

        if($validator->fails())
        {
            return $this->sendError( trans('error.add_fails'), $validator->errors());
        }

        DB::beginTransaction();

        $this->return['id'] = PaymentVoucher::add_payment_voucher($insert_seed);

//        (new ChequeOutgoingHelper)->generate_from_payment_vouchers($this->return['id']);
//
//        $check  = Setting::get_main_setting_by_code('expense_journal')->value ?? false ;
//
//        if($check){
//            $daily_journal = (new PaymentVoucherHelper)->generate_journal($this->return['id']);
//            if(!$daily_journal[0]){
//                DB::rollback();
//                return response()->json(array('check' => 0, 'data' => $daily_journal[3] ?? [], 'msg' => 'Error in createing journal code '.$daily_journal[1]));
//            }
//            PaymentVoucher::update_payment_voucher(['daily_journal_id' => $daily_journal[2]], $this->return['id']);
//        }

        DB::commit();
        return $this->sendResponse($this->return, trans('main.add_success'));
    }

    public function show($lang, $id)
    {
        if(!@in_array('1', $this->data['mypermissions']['06-009'][0]->permission)){
            return $this->sendError('show permission needed #06-009', [], 200);
        }

        $this->return['screen_name']    = ScreenSub::get_screen_sub_by_screen_code('06-009', $lang)->sub_title ?? '';
        $this->return['data']           = PaymentVoucher::get_payment_voucher($id, $lang);
        $this->return['expenses_codes'] = ExpenseCode::all_expense_codes(array('lang' => $lang, 'active' => 1));

        return $this->sendResponse($this->return, trans('main.add_success'));
    }

    public function print_invoice($id)
    {
        $input = Request()->input();

        App::setLocale('ar');

        $this->data['lang']        = 'ar';
        $this->data['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('06-009', $this->data['lang']);
        $this->data['item']        = PaymentVoucher::get_payment_voucher($id, $this->data['lang']);
        $this->data['logo']        = get_logo($this->data['item']->branch_id);
        $this->data['branch_data'] = Branch::get_branch($this->data['item']->branch_id);

        $temp_name  = Setting::get_main_setting_by_code('expenses_print')->value ?? 'temp_1';
        $print_temp = 'Print.expenses.'.$temp_name;

        switch (@$input['type']) {
            case 'excel':
                $this->data['logo'] = public_path().$this->data['logo'];
                $export = new InvoicesExport($this->data, $print_temp);
                return Excel::download($export, 'balances.xlsx');
                break;
            case 'pdf':
                $this->data['logo'] = public_path().$this->data['logo'];
                $pdf = PDF::loadView($print_temp, array('data' => $this->data));
                return $pdf->stream();
                break;
            case 'image':
                $this->data['logo'] = public_path().$this->data['logo'];
                $image = App::make('snappy.image.wrapper');
                $image->loadView($print_temp, array('data' => $this->data));
                return $image->stream();
                break;
            case 'print':
                return view($print_temp)->with('data', $this->data);
                break;
        }
    }
}
