<?php

namespace App\Http\Controllers\API\V1\Sales;
use App\Http\Controllers\API\V1\BaseController;
use App\Models\Sales\CustomerType;
use Illuminate\Http\Request;
use App\Classes\Sales\CustomerTypeHelper;
use App\Models\Main\ScreenSub;
use Illuminate\Validation\Rule;

class CustomerTypeController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang, Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['06-002'][0]->permission)){
            return $this->sendError('view permission needed #06-002', $this->data , 200);
        }

        $this->filter = array(
            'lang'   => $lang ,
            'active' => $request['active'] ?? 1 ,
            'rows'   => $request['rows'] ?? null ,
            'page'   => $request['page'] ?? 1 ,
            'word'   => $request['word'] ?? null ,
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('06-002', $lang)->sub_title ?? '';
        $this->return['items']       = CustomerType::all_customer_types($this->filter);

        return $this->sendResponse($this->return);
    }

    public function create($lang, Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['06-002'][0]->permission)){
            return $this->sendError('create permission needed #06-002', [], 200);
        }

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('06-002', $lang)->sub_title ?? '';

        return $this->sendResponse($this->return);
    }

    public function store($lang, Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['06-002'][0]->permission)){
            return $this->sendError('create permission needed #06-002', [], 200);
        }

        $insert             = $request->only(['name_en', 'name_ar', 'discount_rate']);
        $insert['add_user'] = auth()->user()->id;

        $validator = validator()->make($insert, CustomerType::$rules);

        if($validator->fails())
        {
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }

        $this->return['id'] = CustomerType::add_customer_type($insert);

        return $this->sendResponse($this->return, trans('main.add_success'));
    }

    public function show($lang, $id)
    {
        if(!@in_array('1', $this->data['mypermissions']['06-002'][0]->permission)){
            return $this->sendError('show permission needed #06-002', [], 200);
        }

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('06-002', $lang)->sub_title ?? '';
        $this->return['data']        = CustomerType::get_customer_type($id, $lang);

        return $this->sendResponse($this->return);
    }

    public function update($lang, $id, Request $request)
    {
        if(!@in_array('3', $this->data['mypermissions']['06-002'][0]->permission)){
            return $this->sendError('show permission needed #06-002', [], 200);
        }

        if(!(new CustomerTypeHelper)->can_edit_or_delete($id)){
            return $this->sendError(trans("error.update_fail"));
        }

        $update    = $request->only(['name_en', 'name_ar', 'discount_rate']);
        $update_rules = [
            'name_ar' => [
                'required',
                'string',
                Rule::unique('customer_types')->ignore($id,'customer_type_id'),
            ],
            'name_en' => [
                'required',
                'string',
                Rule::unique('customer_types')->ignore($id,'customer_type_id'),
            ]
        ];
        $validator = validator()->make($update, $update_rules);

        if($validator->fails())
        {
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }

        CustomerType::update_customer_type($update, $id);

        return $this->sendResponse($this->return, trans('main.update_success'));
    }

    public function destroy($lang, $id)
    {
        if(!@in_array('4', $this->data['mypermissions']['06-002'][0]->permission)){
            return $this->sendError('delete permission needed #06-002', [], 200);
        }

        if(!(new CustomerTypeHelper)->can_edit_or_delete($id)){
            return $this->sendError(trans("error.delete_fail"));
        }

        CustomerType::delete_customer_type($id);

        return $this->sendResponse([], trans('main.delete_success'));
    }

    public function toggle_active($lang, $id)
    {
        $item = CustomerType::find($id);

        if($item->customer_type_active){
            if(!@in_array('4', $this->data['mypermissions']['06-002'][0]->permission)){
                return $this->sendError('update permission needed #06-002', [], 200);
            }

            if(!(new CustomerTypeHelper)->can_edit_or_delete($id)){
                return $this->sendError(trans('error.delete_fails'), []);
            }

            CustomerType::delete_customer_type($id);
            $this->return['active'] = false;
        }else{
            if(!@in_array('3', $this->data['mypermissions']['06-002'][0]->permission)){
                return $this->sendError('update permission needed #06-002', [], 200);
            }

            if(!(new CustomerTypeHelper)->can_edit_or_delete($id)){
                return $this->sendError(trans('error.update_fails'), []);
            }

            CustomerType::update_customer_type(array('customer_type_active' => 1), $id);
            $this->return['active'] = true;
        }

        return $this->sendResponse($this->return, trans('main.update_success'));
    }
}
