<?php

namespace App\Http\Controllers\API\V1\Sales;
use App\Http\Controllers\API\V1\BaseController;
use App\Models\Sales\SalesAgent;
use Illuminate\Http\Request;
use App\Classes\Sales\SalesAgentHelper;
use App\Models\Main\ScreenSub;
use App\Models\Main\Branch;
use App\Models\Finance\AccountTree;
use Illuminate\Validation\Rule;


class SalesAgentController extends BaseController
{
    protected $return = array();
    protected $filter = array();

    public function index($lang, Request $request)
    {
        if(!@in_array('1', $this->data['mypermissions']['06-001'][0]->permission)){
            return $this->sendError('view permission needed #06-001', $this->data, 200);
        }

        $this->filter = array(
            'lang'   => $lang ,
            'active' => $request['active'] ?? 1 ,
            'rows'   => $request['rows'] ?? null ,
            'page'   => $request['page'] ?? 1 ,
            'word'   => $request['word'] ?? null ,
        );

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('06-001', $lang)->sub_title ?? '';
        $this->return['items']       = SalesAgent::all_sales_agents($this->filter);

        return $this->sendResponse($this->return);
    }

    public function create($lang, Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['06-001'][0]->permission)){
            return $this->sendError('create permission needed #06-001', [], 200);
        }

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('06-001', $lang)->sub_title ?? '';
        $this->return['account_tree']   = AccountTree::active_account_trees($lang , array('account_type' => 2 , 'active' => 1 ));
        $this->return['branchs']        = Branch::all_branchs( array('lang' => $lang , 'active' => 1 ) );
        return $this->sendResponse($this->return);
    }

    public function store($lang, Request $request)
    {
        if(!@in_array('2', $this->data['mypermissions']['06-001'][0]->permission)){
            return $this->sendError('create permission needed #06-001', [], 200);
        }

        $insert             = $request->only(['name_en', 'name_ar', 'phone', 'commission_rate', 'max_discount']);
        $insert['add_user'] = auth()->user()->id;

        $validator = validator()->make($insert, SalesAgent::$rules);

        if($validator->fails())
        {
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }

        $this->return['id'] = SalesAgent::add_sales_agent($insert);

        return $this->sendResponse($this->return, trans('main.add_success'));
    }

    public function show($lang, $id)
    {
        if(!@in_array('1', $this->data['mypermissions']['06-001'][0]->permission)){
            return $this->sendError('show permission needed #06-001', [], 200);
        }

        $this->return['screen_name'] = ScreenSub::get_screen_sub_by_screen_code('06-001', $lang)->sub_title ?? '';
        $this->return['data']        = SalesAgent::get_sales_agent($id, $lang);
        $this->return['account_tree']   = AccountTree::active_account_trees($lang , array('account_type' => 2 , 'active' => 1 ));
        $this->return['branchs']        = Branch::all_branchs( array('lang' => $lang , 'active' => 1 ) );
        return $this->sendResponse($this->return);
    }

    public function update($lang, $id, Request $request)
    {
        if(!@in_array('3', $this->data['mypermissions']['06-001'][0]->permission)){
            return $this->sendError('show permission needed #06-001', [], 200);
        }

        if(!(new SalesAgentHelper())->can_edit_or_delete($id)){
            return $this->sendError(trans("error.update_fail"));
        }

        $update    = $request->only(['name_en', 'name_ar', 'phone', 'commission_rate', 'max_discount']);
        $update_rules = [
            'name_en' => [
                'required',
                'string',
                Rule::unique('sales_agents')->ignore($id,'sales_agent_id'),
            ],
            'name_ar' => [
                'required',
                'string',
                Rule::unique('sales_agents')->ignore($id,'sales_agent_id'),
            ]
        ];
        $validator = validator()->make($update, $update_rules);

        if($validator->fails())
        {
            return $this->sendError(trans('error.add_fails'), $validator->errors());
        }

        SalesAgent::update_sales_agent($update, $id);

        return $this->sendResponse($this->return, trans('main.update_success'));
    }

    public function destroy($lang, $id)
    {
        if(!@in_array('4', $this->data['mypermissions']['06-001'][0]->permission)){
            return $this->sendError('delete permission needed #06-001', [], 200);
        }

        if(!(new SalesAgentHelper)->can_edit_or_delete($id)){
            return $this->sendError(trans("error.delete_fail"));
        }

        SalesAgent::delete_sales_agent($id);

        return $this->sendResponse([], trans('main.delete_success'));
    }

    public function toggle_active($lang, $id)
    {
        $item = SalesAgent::find($id);

        if($item->sales_agent_active){
            if(!@in_array('4', $this->data['mypermissions']['06-001'][0]->permission)){
                return $this->sendError('update permission needed #06-001', [], 200);
            }

            if(!(new SalesAgentHelper)->can_edit_or_delete($id)){
                return $this->sendError(trans('error.delete_fails'), []);
            }

            SalesAgent::delete_sales_agent($id);
            $this->return['active'] = false;
        }else{
            if(!@in_array('3', $this->data['mypermissions']['06-001'][0]->permission)){
                return $this->sendError('update permission needed #06-001', [], 200);
            }

            if(!(new SalesAgentHelper)->can_edit_or_delete($id)){
                return $this->sendError(trans('error.update_fails'), []);
            }

            SalesAgent::update_sales_agent(array('sales_agent_active' => 1), $id);
            $this->return['active'] = true;
        }

        return $this->sendResponse($this->return, trans('main.update_success'));
    }
}
