<?php
namespace App\Http\Middleware;

use Closure;
use App;

class VerifyAPIBookingAccess
{
    /**
     * Handle an incoming request.
     *
     * @param \Illuminate\Http\Request $request
     * @param \Closure $next
     * @return mixed
     */
    public function handle($request, Closure $next)
    {
        if ( (!$request->header('access-token-booking') || $request->header('access-token-booking') !== env('APP_API_BOOKING_TOKEN') ) ) {
            return response()->json(['check' => false , 'msg' => 'You do not access to this api.' ], 403);
        }

        return $next($request);
    }
}
