<?php

namespace App\Models\Barbers;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class Barber extends Model
{
    protected $primaryKey     = 'barber_m_id';
    public static $main_table = 'barber_m';
    public $table             = 'barber_m';

    public static $master_rules = array(
        'name_en' => 'required|string',
        'name_ar' => 'required|string',
    );

    public static $details_rules = array(
        'barber_m_id'    => 'required|numeric',
        'day_name_en'    => 'required|string',
        'day_name_ar'    => 'required|string',
//        'beginning_work' => 'required',
//        'end_work'       => 'required',
    );

    public static function all_barbers($params = null)
    {
        $query = DB::table(self::$main_table)
            ->orderBy(self::$main_table.'.barber_m_id', 'desc');

        if($params['lang'] != null){
            $query->selectRaw('
                barber_m_id as id ,'.
                self::$main_table.'.name_'.$params['lang'].' as name ,'.
                self::$main_table.'.name_en ,'.
                self::$main_table.'.name_ar ,'.
                self::$main_table.'.categories ,'.
                self::$main_table.'.image ,'.
                self::$main_table.'.barber_active ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user
            ');
        }

        if(isset($params['active']))
            $query->where('barber_active', $params['active']);

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where(self::$main_table.'.name_en', 'LIKE', "%{$params['word']}%")
                    ->orWhere(self::$main_table.'.name_ar', 'LIKE', "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_barber_m($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->where('barber_m_id', $id);

        if($lang != null){
            $query->selectRaw('
                barber_m_id as id ,'.
                self::$main_table.'.name_'.$lang.' as name ,'.
                self::$main_table.'.name_en ,'.
                self::$main_table.'.name_ar ,'.
                self::$main_table.'.categories ,'.
                self::$main_table.'.image ,'.
                self::$main_table.'.barber_active ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user
            ');
        }

        $data = $query->first();
        return $data;
    }

    public static function get_barber_d($id, $lang = null)
    {
        $query = DB::table('barber_d')
            ->where('barber_m_id', $id);

        if($lang != null){
            $query->selectRaw('
                barber_m_id as m_id ,
                barber_d_id as d_id ,
                day_name_'.$lang.' as day_name ,
                day_name_en ,
                day_name_ar ,
                beginning_work ,
                end_work ,
                is_day_off ,
                add_date ,
                add_user
            ');
        }

        $data = $query->get();
        return $data;
    }
    public static function get_barber_lookup($lang = null)
    {
        $query = DB::table('barber_m')
        ->where('barber_active' , 1 )
        ->orderBy('barber_m.barber_m_id', 'desc');

        if($lang != null){
            $query->selectRaw('barber_m_id as id , name_'.$lang.' as name , image');
        }

        $data = $query->get();
        return $data;
    }

    public static function add_barber_m($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function add_barber_d($seed)
    {
        return DB::table('barber_d')->insertGetId($seed);
    }

    public static function update_barber_m($seed, $id)
    {
        return DB::table(self::$main_table)->where('barber_m_id', $id)->update($seed);
    }

    public static function delete_barber_m($id)
    {
        return DB::table(self::$main_table)->where('barber_m_id', $id)->update(array('barber_active' => '0', 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }

    public static function delete_barber_d($id)
    {
        return DB::table('barber_d')->where('barber_m_id', $id)->delete();
    }
}
