<?php
namespace App\Models\Contracts;

use Illuminate\Database\Eloquent\Factories\HasFactory;
use Illuminate\Database\Eloquent\Model;

use DB;

class Contract extends Model
{
    use HasFactory;


    protected $primaryKey       = 'contract_id';
    public static $main_table   = 'contracts';
    public static $main_table_d = 'contract_d';
    protected  $table           = 'contracts';

    public static $rules = array(
        'contract_type_id' => 'required|Integer',
        'customer_id'      => 'required|Integer',
        'amount'           => 'required|numeric',
        'end_date'         => 'required|date',
        'start_date'       => 'required|date',
        'contract_period'  => 'required|Integer',
        'payment_method'   => 'required|Integer',
        'repayment_period' => 'required|Integer'
    );

    public static $rules_delay = array(
        'delay_time' => 'required|date',
    );


    public static function all_contracts($params = null)
    {

        $query = DB::table(self::$main_table)
            ->leftjoin('users', self::$main_table.'.add_user', '=', 'users.id')
            ->leftjoin('contract_types', self::$main_table.'.contract_type_id', '=', 'contract_types.contract_type_id')
            ->leftjoin('customers', self::$main_table.'.customer_id', '=', 'customers.customer_id')
            ->leftjoin('contract_d', self::$main_table.'.contract_id', '=','contract_d.contract_id')
            ->groupBy(self::$main_table.'.contract_id')
            ->orderBy(self::$main_table.'.contract_id','desc')   ;


        if(isset($params['lang'])){
            $query->selectRaw('
                '.self::$main_table.'.contract_id as id,
                '.self::$main_table.'.add_date,
                contract_types.name_'.$params['lang'].' as contract_type_name,
                customers.name_'.$params['lang'].' as customer_name,
                customers.customer_id,
                '.self::$main_table.'.amount,
                '.self::$main_table.'.total_vat  ,
                '.self::$main_table.'.amount_with_vat ,
                end_date,
                start_date,
                contract_period,
                payment_method,
                count( case when contract_d.status = 3 then contract_d_id end ) as paid_installments,
                count( contract_d_id ) as count_installments,
                repayment_period,
                users.username'
            );
        }

        if(isset($params['active'])){
            $query->where('contract_active' , $params['active'] );
        }

        if(isset($params['status'])){
            $query->where('contracts.status' , $params['status'] );
        }

        if(isset($params['customer_id']) && !empty($params['customer_id'])){
            $query->where(function ($stmt) use($params) {
                $stmt->where('customers.customer_id', $params['customer_id']);
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }


    public static function all_contract_d($params = null)
    {

        $query = DB::table(self::$main_table_d)
            ->leftjoin('users', self::$main_table_d.'.add_user', '=', 'users.id')
            ->leftjoin('contracts', self::$main_table_d.'.contract_id', '=', 'contracts.contract_id')
            ->leftjoin('contract_types', self::$main_table.'.contract_type_id', '=', 'contracts.contract_type_id')
            ->leftjoin('customers', self::$main_table.'.customer_id', '=', 'customers.customer_id')
            ->leftjoin('taxes', 'contracts.tax_id', '=', 'taxes.tax_id')
            ->groupBy(self::$main_table_d.'.contract_d_id')
            ->orderBy(self::$main_table_d.'.contract_d_id','desc');

        if(isset($params['lang'])){
            $query->selectRaw('
                contract_d.contract_d_id as id,

                contract_d.status,

                customers.name_'.$params['lang'].' as customer_name ,
                customers.customer_id,
                contract_types.name_'.$params['lang'].' as contract_name ,
                contracts.contract_id,
                (contract_d.installment_paid) as installments_paid ,
                ('.self::$main_table_d.'.amount_with_vat - contract_d.installment_paid) as remaining_amount,

                contracts.tax_id,
                tax_percentage as tax_percent ,
                '.self::$main_table_d.'.installment_amount,
                '.self::$main_table_d.'.total_vat  ,
                '.self::$main_table_d.'.amount_with_vat ,

                delay_time,
                is_delay,

                due_date'
            );
        }

        if(isset($params['active']) && !empty($params['customer'])){
            $query->where('contract_active' , $params['active'] );
        }

        if(isset($params['contract_id']) && !empty($params['contract_id'])){
            $query->where(self::$main_table_d.'.contract_id' , $params['contract_id'] );
        }

        if(isset($params['customer_id']) && !empty($params['customer_id'])){
            $query->where('customers.customer_id', $params['customer_id']);
        }

        if(isset($params['start_date']) && !empty($params['start_date'])){
            $query->where('contracts.start_date', '>=' , $params['start_date']);
        }

        if(isset($params['end_date']) && !empty($params['end_date'])){
            $query->where('contracts.end_date', '<=' ,$params['end_date']);
        }

        if(isset($params['due']) && $params['due'] ){
            $query->where('contract_d.due_date' , '<=' , date("Y-m-d" , strtotime("+7 days")) )
                ->where('contract_d.status', '<' , 3);
        }

        if(isset($params['status']) && !empty($params['status'])){
            $query->where('contract_d.status', $params['status']);
        }

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->Where('contracts.start_date', 'LIKE', "%{$params['word']}%")
                    ->orWhere('contracts.end_date',$params['word'])
                    ->orWhere('contract_d.status',$params['word']);
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }


    public static function get_contract($id , $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('users', self::$main_table.'.add_user', '=', 'users.id')
            ->leftjoin('contract_types', self::$main_table.'.contract_type_id', '=', 'contract_types.contract_type_id')
            ->leftjoin('customers', self::$main_table.'.customer_id', '=', 'customers.customer_id')
            ->leftjoin('contract_d', self::$main_table.'.contract_id', '=', 'contract_d.contract_id')
            ->leftjoin('taxes', self::$main_table.'.tax_id', '=', 'taxes.tax_id')
            ->orderBy(self::$main_table.'.contract_id','desc')
            ->where(self::$main_table.'.contract_id' , $id);

        if($lang != null){
            $query->selectRaw('
                '.self::$main_table.'.contract_id as id,
                '.self::$main_table.'.status,
                contract_types.name_'.$lang.' as contract_name,
                contract_types.contract_type_id,
                '.self::$main_table.'.activation_type,
                '.self::$main_table.'.is_taxable,
                taxes.tax_id,
                taxes.name_'.$lang.' as tax_name,
                taxes.tax_id,
                customers.name_'.$lang.' as customer_name,
                customers.customer_id,
                
                customers.commercial_registeration_no , 
                customers.vat_register_number , 
                customers.address , 

                amount,
                end_date,
                start_date,
                contract_period,
                sum(contract_d.installment_paid) as installments_paid ,
                sum(contracts.amount - contract_d.installment_paid) as installments_remain,
                payment_method,
                repayment_period,
                users.username,
                contracts.notes'
            );
        }

        $data = $query->first();
        return $data;
    }



    public static function get_contract_d($id , $lang = null)
    {
        $query = DB::table(self::$main_table_d)
            ->where(self::$main_table_d.'.contract_id',$id)
            ->leftjoin('users', self::$main_table_d.'.add_user', '=', 'users.id')
            ->leftjoin('contracts', self::$main_table_d.'.contract_id', '=', 'contracts.contract_id')
            ->leftjoin('contract_types', self::$main_table.'.contract_type_id', '=', 'contracts.contract_type_id')
            ->leftjoin('customers', self::$main_table.'.customer_id', '=', 'customers.customer_id')
            ->groupBy(self::$main_table_d.'.contract_d_id')
            ->orderBy(self::$main_table_d.'.contract_d_id','desc');

        if(isset($lang)){
            $query->selectRaw('
                contract_d.contract_d_id as id,
                contract_d.status,
                customers.name_'.$lang.' as customer_name ,
                customers.customer_id,
                contract_types.name_'.$lang.' as contract_name ,
                contracts.contract_id,
                (contract_d.installment_paid) as installments_paid ,
                (installment_amount - contract_d.installment_paid) as remaining_amount,

                '.self::$main_table_d.'.installment_amount,
                '.self::$main_table_d.'.total_vat  ,
                '.self::$main_table_d.'.amount_with_vat ,

                delay_time,
                is_delay,

                due_date'
            );
        }

        if(isset($params['active']) && !isset($params['customer'])){
            $query->where('contract_active' , $params['active'] );
        }



        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }
        return $data;
    }


    public static function all_installments_due($params = null)
    {
        $query = DB::table(self::$main_table_d)
            ->leftjoin('users', self::$main_table_d.'.add_user', '=', 'users.id')
            ->leftjoin('contracts', self::$main_table_d.'.contract_id', '=', 'contracts.contract_id')
            ->leftjoin('contract_types', self::$main_table.'.contract_type_id', '=', 'contracts.contract_type_id')
            ->leftjoin('customers', self::$main_table.'.customer_id', '=', 'customers.customer_id')
            ->where(self::$main_table_d.'.status',1)
            ->WhereBetween(
                self::$main_table_d.'.due_date',[date('Y-m-d',strtotime('+1 day')),date('Y-m-d',strtotime('+5 day'))]
            )->orWhereBetween(
                self::$main_table_d.'.delay_time',[date('Y-m-d',strtotime('+1 day')),date('Y-m-d',strtotime('+5 day'))]
            )
            ->groupBy(self::$main_table_d.'.contract_d_id')
            ->orderBy(self::$main_table_d.'.contract_d_id','desc');

        if(isset($params['lang'])){
            $query->selectRaw('
                contract_d.contract_d_id as id,
                customers.name_'.$params['lang'].' as customer_name ,
                contract_types.name_'.$params['lang'].' as contract_name ,
                contracts.contract_id,
                installment_amount,
                due_date'
            );
        }

        if(isset($params['active']) && !isset($params['customer'])){
            $query->where('contract_d_active' , $params['active'] );
        }


        if(isset($params['customer_id']) && !empty($params['customer_id'])){
            $query->where(function ($stmt) use($params) {
                $stmt->where('customers.customer_id', $params['customer_id']);
            });
        }

        if(isset($params['end_date']) && !empty($params['end_date'])){
            $query->where(function ($stmt) use($params) {
                $stmt->where('contracts.end_date', $params['end_date']);
            });
        }

        if(isset($params['start_date']) && !empty($params['start_date'])){
            $query->where(function ($stmt) use($params) {
                $stmt->where('contracts.start_date', $params['start_date']);
            });
        }


        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }
        return $data;
    }

    public static function get_next($id , $branch){
        return DB::table(self::$main_table)
            ->where('contract_id' , '>' , $id)
            ->where('contract_active' , 1)
            // ->where('branch_id' , $branch)
            ->selectRaw('contract_id as m_id')
            ->first();
    }

    public static function get_previous($id, $branch){
        return DB::table(self::$main_table)
            ->where('contract_id' , '<' , $id)
            ->where('contract_active' , 1)
            // ->where('branch_id' , $branch)
            ->selectRaw('contract_id as m_id')
            ->orderBy('contract_id' , 'desc')
            ->first();
    }

    public static function get_last($branch){
        return DB::table(self::$main_table)
            ->where('contract_active' , 1)
            // ->where('branch_id' , $branch)
            ->selectRaw('contract_id as m_id')
            ->orderBy('contract_id' , 'desc')
            ->first();
    }

    public static function add_contract($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function add_contract_d($seed)
    {
        return DB::table(self::$main_table_d)->insertGetId($seed);
    }

    public static function contract_activation($seed,$id)
    {
        return DB::table(self::$main_table)->where('contract_id' , $id )->update($seed);
    }

    public static function update_contract($seed,$id)
    {
        return DB::table(self::$main_table)->where('contract_id' , $id )->update($seed);
    }

    public static function update_contract_d($seed,$id)
    {
        return DB::table(self::$main_table_d)->where('contract_d_id' , $id )->update($seed);

    }
    public static function delete_contract($id)
    {
        return DB::table(self::$main_table)->where('contract_id' , $id )->update( array('contract_active' => '0' , 'disable_date' => date("Y-m-d H:i:s") , 'disable_user' => auth()->user()->id ));
    }


}
