<?php

namespace App\Models\Finance;

use Illuminate\Database\Eloquent\Model;
use DB;

class CashReceipt extends Model
{

    protected $primaryKey = 'id';

    public static $main_table = 'cash_receipt';
    

    public static $rules = array(
        'user_id' => 'required|numeric',
        'delegate_id' => 'required|numeric',
        'value' => 'required',
        'description' => 'required|string|min:3'
    );

    public static function active_cash_receipt($lang = null , $params = null)
    {
        $query =  DB::table(self::$main_table);

        if($lang != null){
            $query->selectRaw('
            id  , 
            date ,
            from_type ,
            user_id ,
            delegate_id , 
            value , 
            description , 
            advance_payment ,
            cost_center_id ,
            cost_center ,
            collection_method ,
            bank_id 
            ');
        }

        if(isset($params['active']))
            $query->where('active' , $params['active']);
        
        $data = $query->get();
    return $data;
    }

    public static function get_cash_receipt($id , $lang = null)
    {
        $query =  DB::table(self::$main_table)
            ->where('id' , $id);

        if($lang != null){
            $query->selectRaw('
            id  , 
            date ,
            from_type ,
            user_id ,
            delegate_id , 
            value , 
            description , 
            advance_payment ,
            cost_center_id ,
            cost_center ,
            collection_method ,
            bank_id 
            ');
        }
        
        $data = $query->first();
        return $data;

    }

    public static function add_cash_receipt($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_cash_receipt($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('id' , $id )->update($seed);
    }

    public static function delete_cash_receipt($id)
    {
        return DB::table(self::$main_table)->where('id' , $id )->delete();
    }
}
