<?php

namespace App\Models\Finance;

use Illuminate\Database\Eloquent\Model;
use DB;

class ExpenseCode extends Model
{
    protected $primaryKey = 'expense_code_id';
    public static $main_table = 'expense_codes';
    public $table = 'expense_codes';

    public static $rules = array(
        'name_en'         => 'required|string|unique:expense_codes',
        'name_ar'         => 'required|string|unique:expense_codes',
        'account_tree_id' => 'required|numeric',
        'cost_center_id'  => 'nullable|numeric',
    );

    public static function all_expense_codes($params = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('account_tree', self::$main_table.'.account_tree_id', '=', 'account_tree.account_tree_id')
            ->leftjoin('cost_center', self::$main_table.'.cost_center_id', '=', 'cost_center.cost_center_id')
            ->orderBy(self::$main_table.'.expense_code_id', 'desc');

        if($params['lang'] != null){
            $query->selectRaw('
                expense_code_id as id ,'.
                self::$main_table.'.name_en ,'.
                self::$main_table.'.name_ar ,'.
                self::$main_table.'.account_tree_id ,
                account_tree.name_'.$params['lang'].' as account_tree_name ,'.
                self::$main_table.'.cost_center_id ,
                cost_center.name_'.$params['lang'].' as cost_center_name ,'.
                self::$main_table.'.expense_code_active ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user
            ');
        }

        if(isset($params['active']))
            $query->where('expense_code_active', $params['active']);

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where(self::$main_table.'.name_en' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere(self::$main_table.'.name_ar' , 'LIKE' , "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_expense_code($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('account_tree', self::$main_table.'.account_tree_id', '=', 'account_tree.account_tree_id')
            ->leftjoin('cost_center', self::$main_table.'.cost_center_id', '=', 'cost_center.cost_center_id')
            ->where('expense_code_id' , $id);

        if($lang != null){
            $query->selectRaw('
                expense_code_id as id ,'.
                self::$main_table.'.name_en ,'.
                self::$main_table.'.name_ar ,'.
                self::$main_table.'.account_tree_id ,
                account_tree.name_'.$lang.' as account_tree_name ,'.
                self::$main_table.'.cost_center_id ,
                cost_center.name_'.$lang.' as cost_center_name ,'.
                self::$main_table.'.expense_code_active ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user
            ');
        }

        $data = $query->first();
        return $data;
    }

    public static function add_expense_code($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_expense_code($seed, $id)
    {
        return DB::table(self::$main_table)->where('expense_code_id', $id)->update($seed);
    }

    public static function delete_expense_code($id)
    {
        return DB::table(self::$main_table)->where('expense_code_id', $id)->update(array('expense_code_active' => '0', 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }
}
