<?php

namespace App\Models\Inventory;

use Illuminate\Database\Eloquent\Model;
use DB;

class Stocktaking extends Model
{
    protected $primaryKey       = 'stocktaking_m_id';
    public static $main_table   = 'stocktaking_m';
    public $table               = 'stocktaking_m';

    public static $master_rules = array(
        'stocktaking_date' => 'required|date',
        'warehouse_id'     => 'required|numeric',
        'branch_id'        => 'required|numeric',
        'finance_year_id'  => 'required|numeric',
        'year_ser'         => 'required|numeric',
        'month_ser'        => 'required|numeric',
        'branch_ser'       => 'required|numeric',
    );

    public static $details_rules = array(
        'item_id'  => 'required|numeric',
        'unit_id'  => 'required|numeric',
    );

    public static function all_stocktakings($params = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('warehouses', self::$main_table.'.warehouse_id', '=', 'warehouses.warehouse_id')
            ->leftjoin('users', self::$main_table.'.add_user', '=', 'users.id')
            ->orderBy(self::$main_table.'.stocktaking_m_id', 'desc');

        if($params['lang'] != null){
            $query->selectRaw('
                stocktaking_m_id as m_id ,'.
                self::$main_table.'.stocktaking_date ,'.
                self::$main_table.'.warehouse_id ,
                warehouses.name_'.$params['lang'].' as warehouse_name ,'.
                self::$main_table.'.branch_id ,'.
                self::$main_table.'.finance_year_id ,'.
                self::$main_table.'.stocktaking_status ,'.
                self::$main_table.'.stocktaking_active ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user ,
                users.username as added_by
            ');
        }

        if(isset($params['active']))
            $query->where(self::$main_table.'.stocktaking_active', $params['active']);

        if(isset($params['warehouse_id']))
            $query->where(self::$main_table.'.warehouse_id', $params['warehouse_id']);

        if(isset($params['from_date']) && $params['from_date'] > date("Y-m-d", strtotime("2000-01-01"))){
            $query->where(self::$main_table.'.stocktaking_date', '>=', $params['from_date']);
        }

        if(isset($params['to_date']) && $params['to_date'] > date("Y-m-d", strtotime("2000-01-01"))){
            $query->where(self::$main_table.'.stocktaking_date', '<=', $params['to_date']);
        }

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where('warehouses.name_en', 'LIKE', "%{$params['word']}%")
                    ->orWhere('warehouses.name_ar', 'LIKE', "%{$params['word']}%")
                    ->orWhere('users.username', 'LIKE', "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_stocktaking_m($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('warehouses', self::$main_table.'.warehouse_id', '=', 'warehouses.warehouse_id')
            ->leftjoin('users' , self::$main_table.'.add_user' , '=' , 'users.id')
            ->where('stocktaking_m_id', $id);

        if($lang != null){
            $query->selectRaw('
                stocktaking_m_id as m_id ,'.
                self::$main_table.'.stocktaking_date ,'.
                self::$main_table.'.warehouse_id ,
                warehouses.name_'.$lang.' as warehouse_name ,'.
                self::$main_table.'.branch_id ,'.
                self::$main_table.'.finance_year_id ,'.
                self::$main_table.'.stocktaking_status ,'.
                self::$main_table.'.stocktaking_active ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user ,
                users.username as added_by
            ');
        }

        $data = $query->first();
        return $data;
    }

    public static function get_stocktaking_d($id, $lang = null)
    {
        $query = DB::table('stocktaking_d')
            ->leftjoin('items', 'stocktaking_d.item_id', '=', 'items.item_id')
            ->leftjoin('unit_measurements', 'stocktaking_d.unit_id', '=', 'unit_measurements.unit_measurement_id')
            ->where('stocktaking_m_id', $id);

        if($lang != null){
            $query->selectRaw('
                stocktaking_m_id as m_id ,
                stocktaking_d_id as d_id ,
                stocktaking_d.item_id ,
                items.name_'.$lang.' as item_name ,
                stocktaking_d.unit_id ,
                unit_measurements.name_'.$lang.' as unit_name ,
                stocktaking_d.unit_type ,
                stocktaking_d.current_balance ,
                stocktaking_d.stocktaking_balance ,
                stocktaking_d.difference ,
                stocktaking_d.add_date ,
                stocktaking_d.add_user
            ');
        }

        $data = $query->get();
        return $data;
    }

    public static function add_stocktaking_m($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function add_stocktaking_d($seed)
    {
        return DB::table('stocktaking_d')->insertGetId($seed);
    }

    public static function update_stocktaking_m($seed, $id)
    {
        return DB::table(self::$main_table)->where('stocktaking_m_id', $id)->update($seed);
    }

    public static function delete_stocktaking_m($id)
    {
        return DB::table(self::$main_table)->where('stocktaking_m_id', $id)->update(array('stocktaking_active' => '0', 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }

    public static function delete_stocktaking_d($id)
    {
        return DB::table('stocktaking_d')->where('stocktaking_m_id', $id)->delete();
    }
}
