<?php

namespace App\Models\Inventory;

use Illuminate\Database\Eloquent\Model;
use DB;

class Warehouse extends Model
{
    protected $primaryKey     = 'warehouse_id';
    public static $main_table = 'warehouses';
    public $table             = 'warehouses';

    public static $rules = array(
        'name_en'         => 'required|string|unique:warehouses' ,
        'name_ar'         => 'required|string|unique:warehouses' ,
        'account_tree_id' => 'required|numeric' ,
    );

    public static function all_warehouses($params = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('account_tree', self::$main_table.'.account_tree_id', '=', 'account_tree.account_tree_id')
            ->orderBy(self::$main_table.'.warehouse_id', 'desc');

        if( isset($params['lang']) )
            $query->selectRaw('
                warehouse_id as id ,'.
                self::$main_table.'.name_'.$params['lang'].' as name ,'.
                self::$main_table.'.name_ar ,'.
                self::$main_table.'.name_en ,'.
                self::$main_table.'.account_tree_id ,
                account_tree.name_'.$params['lang'].' as account_name ,'.
                self::$main_table.'.warehouse_status,'.
                self::$main_table.'.warehouse_active,'.
                self::$main_table.'.add_date,'.
                self::$main_table.'.add_user
            ');

        if(isset($params['active']))
            $query->where('warehouse_active', $params['active']);

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where(self::$main_table.'.name_en' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere(self::$main_table.'.name_ar' , 'LIKE' , "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_warehouse($id , $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('account_tree', self::$main_table.'.account_tree_id', '=', 'account_tree.account_tree_id')
            ->where('warehouse_id' , $id);

        $query->selectRaw('
            warehouse_id as id ,'.
            self::$main_table.'.name_'.$lang.' as name ,'.
            self::$main_table.'.name_ar ,'.
            self::$main_table.'.name_en ,'.
            self::$main_table.'.account_tree_id ,
            account_tree.name_'.$lang.' as account_name ,'.
            self::$main_table.'.warehouse_status,'.
            self::$main_table.'.warehouse_active,'.
            self::$main_table.'.add_date,'.
            self::$main_table.'.add_user
        ');

        $data = $query->first();
        return $data;
    }

    public static function add_warehouse($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_warehouse($seed, $id)
    {
        return DB::table(self::$main_table)->where('warehouse_id', $id)->update($seed);
    }

    public static function delete_warehouse($id)
    {
        return DB::table(self::$main_table)->where('warehouse_id', $id)->update(array('warehouse_active' => 0, 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }
}
