<?php

namespace App\Models\Main;

use Illuminate\Database\Eloquent\Model;
use DB;

class Bank extends Model
{

    protected $primaryKey = 'bank_id';

    public static $main_table = 'banks';

    public static $rules = array(
        'name_en'           => 'required|string' ,
        'name_ar'           => 'required|string' ,
        'account_tree_id'         => 'required|numeric' ,
        'mastercard'        => 'required',
        'visa'              => 'required' ,
        'mada'              => 'required'
    );



    public static function all_banks($params = null)
    {
        $query =  DB::table(self::$main_table)
            ->orderBy('bank_order');

        if( isset($params['lang']) )
            $query->selectRaw('bank_id as id , name_'.$params['lang'].' as name  , account_tree_id , mastercard, visa , mada , add_date');

        if(isset($params['active']))
            $query->where('bank_active' , $params['active'] );
        
        if(isset($params['word']) && strlen($params['word']) >  0){

            $query->where(function ($stmt) use($params) {
                $stmt->where('name_en' , 'LIKE' , "%{$params['word']}%")
                ->orWhere('name_ar' , 'LIKE' , "%{$params['word']}%");
            });
            
        }

        
        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_bank($id , $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->where('bank_id' , $id);

        if($lang != null){
            $query->selectRaw('bank_id as id , name_'.$lang.' as name , account_tree_id , mastercard, visa , mada , add_date');
        }

        $data = $query->first();

        return $data;
    }

    public static function add_bank($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_bank($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('bank_id' , $id )->update($seed);
    }

    public static function delete_bank($id)
    {
        return DB::table(self::$main_table)->where('bank_id' , $id )->update( array('bank_active' => '0' , 'disable_date' => date("Y-m-d H:i:s") , 'disable_user' => auth()->user()->id));
    }
}
