<?php

namespace App\Models\Main;

use Illuminate\Database\Eloquent\Model;
use DB;

class NetworkMachine extends Model
{
    protected $primaryKey = 'network_machine_id';

    protected $table = 'network_machines';

    public static $main_table = 'network_machines';

    public static $rules = array(
        'name_en'      => 'required|string' ,
        'name_ar'      => 'required|string' ,
        'account_tree_id'         => 'required|numeric' ,
        'branch_id'         => 'required|numeric' ,
        'bank_id'         => 'required|numeric' ,
    );

    public static function all_network_machines($params = null)
    {
        $query =  DB::table(self::$main_table);

        if( isset($params['lang']) )
            $query->selectRaw('network_machine_id as id , name_'.$params['lang'].' as name  , account_tree_id , branch_id , bank_id , add_date');

        if(isset($params['active']))
            $query->where('network_machine_active' , $params['active'] );


        if(isset($params['branch']))
            $query->where('branch_id' , $params['branch'] );

        if(isset($params['word']) && strlen($params['word']) >  0){

            $query->where(function ($stmt) use($params) {
                $stmt->where('name_en' , 'LIKE' , "%{$params['word']}%")
                ->orWhere('name_ar' , 'LIKE' , "%{$params['word']}%");
            });
            
        }
        
        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_network_machine($id , $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->where('network_machine_id' , $id);

        if($lang != null){
            $query->selectRaw('network_machine_id as id , name_'.$lang.' as name  , account_tree_id , branch_id, bank_id , add_date');
        }

        $data = $query->first();

        return $data;
    }

    public static function add_network_machine($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_network_machine($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('network_machine_id' , $id )->update($seed);
    }

    public static function delete_network_machine($id)
    {
        return DB::table(self::$main_table)->where('network_machine_id' , $id )->update( array('network_machine_active' => '0' , 'disable_date' => date("Y-m-d H:i:s") , 'disable_user' => auth()->user()->id));
    }
}
