<?php

namespace App\Models\Main;

use Illuminate\Database\Eloquent\Model;
use DB;

class Notiffications extends Model
{
    protected $primaryKey     = 'id';
    public static $main_table = 'notiffications';
    public $table             = 'notiffications';

    public static $rules = array(
    );

    public static function all_notifficationss($params = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('users' ,'users.id' ,'notiffications.add_user')
            ->orderBy(self::$main_table.'.id', 'desc');

        if(isset($params['lang']))
            $query->selectRaw('
                notiffications.id ,
                notiffications.title,
                description ,
                type,
                action_id,
                users.user_full_name ,
                add_date ,
                users_read,
                add_user,
                IF(FIND_IN_SET(?, users_read), 1, 0) AS is_read
                ', [auth()->user()->id]
            );

        if(isset($params['type']))
            $query->where('type', $params['type']);

        if(isset($params['action_id']))
            $query->where('action_id', $params['action_id']);
        
        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_notiffications($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->where('id', $id);

        $query->selectRaw('
                *
        ');

        $data = $query->first();
        return $data;
    }

    public static function add_notiffication($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

}
