<?php

namespace App\Models\Main;

use Illuminate\Database\Eloquent\Model;
use DB;

class ScreenMain extends Model
{

    protected $primaryKey = 'screen_main_id';

    public static $main_table = 'screen_mains';


    public static $rules = array(
        'screen_main_title_en' => 'required|string|min:3',
        'screen_main_title_ar' => 'required|string|min:3',
    );

    public static function all_screen_mains($params = null)
    {
        $query =  DB::table(self::$main_table)
            ->orderBy('screen_main_order');

        if(isset($params['lang'])){
            $query->selectRaw(
                self::$main_table.'.screen_main_id as id ,
                screen_main_title_'.$params['lang'].' as title ,
                screen_main_image as image'
            );
        }

        if(isset($params['active']))
            $query->where('screen_main_active' , $params['active'] );


        if(isset($params['word']) && strlen($params['word']) >  0){

            $query->where(function ($stmt) use($params) {
                $stmt->where('screen_main_title_en' , 'LIKE' , "%{$params['word']}%")
                ->orWhere('screen_main_title_ar' , 'LIKE' , "%{$params['word']}%");
            });

        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_screen_main($id)
    {
        return DB::table(self::$main_table)
            ->where('screen_main_id' , $id)
            ->first();
    }

    public static function add_screen_main($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_screen_main($seed ,  $id)
    {
        return DB::table(self::$main_table)->where('screen_main_id' , $id )->update($seed);
    }

    public static function delete_screen_main($id)
    {
        return DB::table(self::$main_table)->where('screen_main_id' , $id )->update( array('screen_main_active' => '0' , 'disable_date' => date("Y-m-d H:i:s") , 'disable_user' => auth()->user()->id )   );
    }

}
