<?php

namespace App\Models\Manufacturing;

use Illuminate\Database\Eloquent\Model;
use Illuminate\Support\Facades\DB;

class WorkOrders extends Model
{
    protected $primaryKey     = 'order_m_id';
    public static $main_table = 'work_orders_m';
    public $table             = 'work_orders_m';

    public static $rules = array(

    );

    public static function all_work_orders($params = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('elevators_quotations','elevators_quotations.quotation_id' , 'work_orders_m.contract_id')
            ->leftJoin('customers', 'elevators_quotations.customer_id','customers.customer_id')
            ->leftJoin('citys', 'elevators_quotations.city_id','citys.city_id')
            ->leftJoin('elevators_types', 'elevators_quotations.type_id','elevators_types.type_id')
            ->leftJoin('quotations_payments', 'elevators_quotations.quotation_id','quotations_payments.quotation_id')
            ->leftJoin('quotations_payments_installments', 'quotations_payments_installments.payment_id','quotations_payments.payment_id')
            ->groupBy(self::$main_table.'.order_m_id');

        if(isset($params['lang']))
            $query->selectRaw('
                work_orders_m.order_m_id ,
                work_orders_m.action_date ,
                work_orders_m.contract_id ,
                elevators_quotations.invoice_code as contract_number ,
                elevators_quotations.customer_id ,
                customers.name_'.$params['lang'].' as customer_name,
                customers.phone ,
                elevators_quotations.city_id ,
                citys.name_'.$params['lang'].' as city_name,
                elevators_quotations.type_id ,
                elevators_types.name_'.$params['lang'].' as type_name,
                elevators_quotations.elevators_count ,
                elevators_quotations.floors_count ,
                elevators_quotations.price ,
                SUM(quotations_payments_installments.amount) as paid,
                work_orders_m.active ,
                work_orders_m.add_date ,
                work_orders_m.add_user
            ');

        if(isset($params['active']))
            $query->where('work_orders_m.active', $params['active']);

        if(isset($params['contract_id']))
            $query->where('elevators_quotations.quotation_id', $params['active']);

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where(self::$main_table.'.contract_id' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere('elevators_quotations.invoice_code' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere('customers.name_en' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere('customers.name_ar' , 'LIKE' , "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_order_m($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('elevators_quotations','elevators_quotations.quotation_id' , 'work_orders_m.contract_id')
            ->leftJoin('customers', 'elevators_quotations.customer_id','customers.customer_id')
            ->leftJoin('citys', 'elevators_quotations.city_id','citys.city_id')
            ->leftJoin('elevators_types', 'elevators_quotations.type_id','elevators_types.type_id')
            ->leftJoin('quotations_payments', 'elevators_quotations.quotation_id','quotations_payments.quotation_id')
            ->leftJoin('quotations_payments_installments', 'quotations_payments_installments.payment_id','quotations_payments.payment_id')
            ->where('order_m_id', $id);

        if($lang != null)
            $query->selectRaw('
                work_orders_m.order_m_id ,
                work_orders_m.action_date ,
                work_orders_m.contract_id ,
                elevators_quotations.invoice_code as contract_number ,
                elevators_quotations.customer_id ,
                customers.name_'.$lang.' as customer_name,
                customers.phone ,
                elevators_quotations.city_id ,
                citys.name_'.$lang.' as city_name,
                elevators_quotations.type_id ,
                elevators_types.name_'.$lang.' as type_name,
                elevators_quotations.elevators_count ,
                elevators_quotations.floors_count ,
                elevators_quotations.price ,
                SUM(quotations_payments_installments.amount) as paid,
                work_orders_m.active ,
                work_orders_m.add_date ,
                work_orders_m.add_user
            ');

        $data = $query->first();
        return $data;
    }
    public static function get_contract_orders($id = null , $order_id = null , $lang = null)
    {
        $query = DB::table('work_orders_d')
            ->leftjoin('work_orders_m','work_orders_m.order_m_id' , 'work_orders_d.order_m_id')
            ->leftjoin('elevators_quotations','elevators_quotations.quotation_id' , 'work_orders_m.contract_id')
            ->leftJoin('customers', 'elevators_quotations.customer_id','customers.customer_id')
            ->leftJoin('manufacturing_m', 'manufacturing_m.order_m_id', '=', 'work_orders_m.order_m_id')
            ->where('work_orders_m.active', 1)
            ->whereNull('manufacturing_m.order_m_id');
        if($lang != null)
            $query->selectRaw('
                work_orders_d.order_m_id ,
                work_orders_m.action_date ,
                work_orders_m.contract_id ,
                elevators_quotations.invoice_code as contract_number ,
                elevators_quotations.customer_id ,
                customers.name_'.$lang.' as customer_name,
                work_orders_d.term_name ,
                work_orders_d.term_description

            ');
            if(isset($id)){
                $query->where('work_orders_m.contract_id', $id);
            }
            if(isset($order_id)){
                $query->where('work_orders_m.order_m_id', $order_id);
            }

        $data = $query->get()->groupBy('order_m_id');
        return $data;
    }
    public static function get_order_d($id, $lang = null)
    {
        $query = DB::table('work_orders_d')
            ->where('order_m_id', $id);

        if($lang != null)
            $query->selectRaw('
                *
            ');

        $data = $query->get();
        return $data;
    }
    public static function get_attachments($id, $lang = null)
    {
        $query = DB::table('work_orders_attachments')
            ->where('order_m_id', $id);

        if($lang != null)
            $query->selectRaw('
                *
            ');

        $data = $query->get();
        return $data;
    }
    public static function delete_attachment($id, $lang = null)
    {
        return DB::table('work_orders_attachments')->where('attachment_id', $id)->delete();
    }
    public static function add_order_m($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }
    public static function add_order_d($seed)
    {
        return DB::table('work_orders_d')->insertGetId($seed);
    }
    public static function update_order($seed, $id)
    {
        return DB::table(self::$main_table)->where('order_m_id', $id)->update($seed);
    }

    public static function delete_order($id)
    {
        return DB::table(self::$main_table)->where('order_m_id', $id)->update( array('active' => 0, 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }
}
