<?php

namespace App\Models\POS;

use Illuminate\Database\Eloquent\Model;
use DB;

class NoticeDebtor extends Model
{
    protected $primaryKey = 'notice_debtor_m_id';

    public static $main_table = 'notice_debtors_m';

    public static function all_notice_debtors($params = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('sales_invoice_m', self::$main_table.'.sales_invoice_m_id', '=', 'sales_invoice_m.sales_invoice_m_id')
            ->leftjoin('customers', self::$main_table.'.customer_id', '=', 'customers.customer_id')
            ->leftjoin('customer_types', 'customers.customer_type_id', '=', 'customer_types.customer_type_id')
            ->leftjoin('branchs', self::$main_table.'.branch_id', '=', 'branchs.branch_id')
            ->leftjoin('finance_years', self::$main_table.'.finance_year_id', '=', 'finance_years.finance_year_id')
            ->leftjoin('users', self::$main_table.'.add_user', '=', 'users.id')
            ->leftjoin('daily_journal_m', self::$main_table.'.daily_journal_m_id', '=', 'daily_journal_m.daily_journal_m_id')
            ->where('notice_debtor_active', 1)
            ->orderBy(self::$main_table.'.notice_debtor_m_id', 'desc');

        if($params['lang'] != null){
            $query->selectRaw('
                notice_debtor_m_id as m_id ,'.
                self::$main_table.'.sales_invoice_m_id ,'.
                self::$main_table.'.branch_id ,
                branchs.name_'.$params['lang'].' as branch_name ,
                branchs.vat_register_name ,'.
                self::$main_table.'.finance_year_id ,
                finance_years.name as finance_year_name ,
                daily_journal_m.daily_journal_m_id ,
                daily_journal_m.year_ser as journal_code , '.
                self::$main_table.'.year_ser ,'.
                self::$main_table.'.branch_ser ,'.
                self::$main_table.'.month_ser ,'.
                self::$main_table.'.invoice_date ,'.
                self::$main_table.'.customer_id ,
                customers.name_'.$params['lang'].' as customer_name ,
                customers.phone as customer_phone ,
                if(invoice_hash IS NOT NULL, true, false ) as zatca ,
                customers.vat_register_number as customer_vat_register_number ,
                customers.customer_type_id ,
                customer_types.name_'.$params['lang'].' as customer_type_name ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user ,
                users.user_full_name
            ');
        }

        if(isset($params['branch']) && is_array($params['branch'])){
            $query->whereIn(self::$main_table.'.branch_id', $params['branch']);
        }elseif(isset($params['branch'])){
            $query->where(self::$main_table.'.branch_id', $params['branch']);
        }

        if(isset($params['finance_year_id']) && is_array($params['finance_year_id'])){
            $query->whereIn(self::$main_table.'.finance_year_id', $params['finance_year_id']);
        }elseif(isset($params['finance_year_id'])){
            $query->where(self::$main_table.'.finance_year_id', $params['finance_year_id']);
        }

        if(isset($params['shift'])){
            $query->where(self::$main_table.'.shift_id', $params['shift']);
        }

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where(self::$main_table.'.notice_debtor_m_id', 'LIKE', "%{$params['word']}%")
                    ->orWhere(self::$main_table.'.sales_invoice_m_id', 'LIKE', "%{$params['word']}%")
                    ->orWhere('customers.name_ar', 'LIKE', "%{$params['word']}%")
                    ->orWhere('customers.name_en', 'LIKE', "%{$params['word']}%")
                    ->orWhere('customers.phone', 'LIKE', "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_notice_debtor_m($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('customers', self::$main_table.'.customer_id', '=', 'customers.customer_id')
            ->leftjoin('customer_types', 'customers.customer_type_id', '=', 'customer_types.customer_type_id')
            ->leftjoin('branchs', self::$main_table.'.branch_id', '=', 'branchs.branch_id')
            ->leftjoin('finance_years', self::$main_table.'.finance_year_id', '=', 'finance_years.finance_year_id')

            ->leftjoin('sales_invoice_types', self::$main_table.'.sales_invoice_type_id', '=', 'sales_invoice_types.sales_invoice_type_id')
            ->leftjoin('network_machines', self::$main_table.'.machine_id', '=', 'network_machines.network_machine_id')
            ->leftjoin('treasurys', self::$main_table.'.treasury_id', '=', 'treasurys.treasury_id')

            ->leftjoin('users', self::$main_table.'.add_user', '=', 'users.id')
            // ->where('notice_debtor_active', 1)
            ->where('notice_debtor_m_id', $id);

        if($lang != null){
            $query->selectRaw('
                notice_debtor_m_id as m_id ,'.
                self::$main_table.'.sales_invoice_m_id ,'.
                self::$main_table.'.branch_id ,
                branchs.name_'.$lang.' as branch_name ,
                branchs.vat_register_name ,'.
                self::$main_table.'.finance_year_id ,
                finance_years.name as finance_year_name , '.
                self::$main_table.'.year_ser ,'.
                self::$main_table.'.branch_ser ,'.
                self::$main_table.'.month_ser ,'.
                self::$main_table.'.invoice_date ,'.

                self::$main_table.'.daily_journal_m_id ,'.
                self::$main_table.'.customer_id ,
                customers.name_'.$lang.' as customer_name ,
                customers.phone as customer_phone ,
                customers.vat_register_number as customer_vat_register_number ,
                customers.account_tree_id as customer_account_tree_id ,
                notice_debtor_active as active ,
                sales_invoice_types.sales_invoice_type_id ,
                treasurys.account_tree_id as treasury_account_tree_id ,
                network_machines.account_tree_id as machine_account_tree_id ,

                customers.customer_type_id ,
                customer_types.name_'.$lang.' as customer_type_name ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user ,
                users.user_full_name
            ');
        }

        $data = $query->first();
        return $data;
    }

    public static function get_notice_debtor_d($id, $lang = null)
    {
        $query = DB::table('notice_debtors_d')
            ->leftjoin('items', 'notice_debtors_d.item_id', '=', 'items.item_id')
            ->leftjoin('warehouses', 'notice_debtors_d.warehouse_id', '=', 'warehouses.warehouse_id')
            ->leftjoin('unit_measurements', 'notice_debtors_d.unit_id', '=', 'unit_measurements.unit_measurement_id')
            ->leftjoin('taxes', 'items.tax_id', '=', 'taxes.tax_id')
            ->where('notice_debtor_m_id', $id);

        if($lang != null){
            $query->selectRaw('
                notice_debtor_m_id as m_id ,
                notice_debtor_d_id as d_id ,
                notice_debtors_d.sales_invoice_d_id ,
                notice_debtors_d.item_id ,
                items.name_'.$lang.' as item_name ,
                notice_debtors_d.warehouse_id ,
                warehouses.name_'.$lang.' as warehouse_name ,
                notice_debtors_d.unit_id ,
                unit_measurements.name_'.$lang.' as unit_name ,

                items.sales_revenue_id ,
                taxes.account_tree_id as tax_account_tree_id ,

                old_quantity ,
                old_total_vat  ,
                old_total_without_vat ,
                old_total_with_vat ,
                new_quantity,
                new_total_vat  ,
                new_total_without_vat  ,
                new_total_with_vat
            ');
        }

        $data = $query->get();
        return $data;
    }

    public static function get_payments($id, $lang)
    {
        return DB::table('notice_payments')
            ->leftjoin('network_machines', 'notice_payments.machine_id', '=', 'network_machines.network_machine_id')
            ->where('notice_debtor_m_id', $id)
            ->selectRaw('* , network_machines.name_'.$lang.' as machine_name')
            ->get();
    }

    public static function add_notice_debtor_m($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function add_notice_debtor_d($seed)
    {
        return DB::table('notice_debtors_d')->insertGetId($seed);
    }

    public static function update_notice_debtor_m($seed, $id)
    {
        return DB::table(self::$main_table)->where('notice_debtor_m_id', $id)->update($seed);
    }

    public static function update_return_invoice_d($seed, $id)
    {
        return DB::table('notice_debtors_d')->where('notice_debtor_d_id', $id)->update($seed);
    }

    public static function delete_return_invoice_m($id)
    {
        return DB::table(self::$main_table)->where('notice_debtor_m_id', $id)->update(array('notice_debtor_active' => 0));
    }

    public static function delete_return_invoice_d($id)
    {
        return DB::table('notice_debtors_d')->where('notice_debtor_d_id', $id)->delete();
    }
}
