<?php

namespace App\Models\Purchases;

use Illuminate\Database\Eloquent\Model;
use DB;

class PurchasesOrder extends Model
{
    protected $primaryKey     = 'purchases_order_m_id';
    public static $main_table = 'purchases_order_m';
    public $table             = 'purchases_order_m';

    public static $master_rules = array(
        'purchases_order_date'        => 'required|date',
        'purchases_order_no_date'     => 'required|date',
//        'purchases_order_description' => 'required',
        'purchases_vendor_id'         => 'required|numeric',
        'payment_method_id'           => 'required|numeric',
        'receiving_palace'            => 'required|string',
        'transportation'              => 'required|string',
        'offer_due_term'              => 'required|numeric',
    );

    public static $details_rules = array(
        'warehouse_id'   => 'required|numeric',
        'item_id'        => 'required|numeric',
        'unit_id'        => 'required|numeric',
        'quantity'       => 'required|numeric',
        'price'          => 'required',
        'tax_percent_id' => 'required|numeric',
    );

    public static function all_purchases_orders($params = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('purchases_vendors' , self::$main_table.'.purchases_vendor_id' , '=' , 'purchases_vendors.purchases_vendor_id')
            ->leftjoin('payment_methods' , self::$main_table.'.payment_method_id' , '=' , 'payment_methods.payment_method_id')
            ->orderBy(self::$main_table.'.purchases_order_m_id', 'desc');

        if($params['lang'] != null){
            $query->selectRaw('
                purchases_order_m_id as m_id ,
                purchases_order_date ,
                purchases_order_no_date ,
                purchases_order_description ,'.
                self::$main_table.'.purchases_vendor_id ,
                purchases_vendors.name_'.$params['lang'].' as purchases_vendor_name ,'.
                self::$main_table.'.payment_method_id ,
                payment_methods.name_'.$params['lang'].' as payment_method_name ,
                branch_id ,
                finance_year_id ,
                receiving_palace ,
                transportation ,
                offer_due_term ,
                total_vat ,
                total_without_vat ,
                total_with_vat ,
                purchases_order_status ,
                purchases_order_active ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user
            ');
        }

        if(isset($params['active']))
            $query->where('purchases_order_active', $params['active']);

        if(isset($params['status']))
            $query->where('purchases_order_status', $params['status']);

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where('purchases_order_description', 'LIKE', "%{$params['word']}%")
                    ->orWhere('purchases_vendors.name_ar', 'LIKE', "%{$params['word']}%")
                    ->orWhere('purchases_vendors.name_en', 'LIKE', "%{$params['word']}%")
                    ->orWhere('payment_methods.name_ar', 'LIKE', "%{$params['word']}%")
                    ->orWhere('payment_methods.name_en', 'LIKE', "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_purchases_order_m($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('purchases_vendors' , self::$main_table.'.purchases_vendor_id' , '=' , 'purchases_vendors.purchases_vendor_id')
            ->leftjoin('payment_methods' , self::$main_table.'.payment_method_id' , '=' , 'payment_methods.payment_method_id')
            ->where('purchases_order_m_id' , $id);

        if($lang != null){
            $query->selectRaw('
                purchases_order_m_id as m_id ,
                purchases_order_date ,
                purchases_order_no_date ,
                purchases_order_description ,'.
                self::$main_table.'.purchases_vendor_id ,
                purchases_vendors.name_'.$lang.' as purchases_vendor_name ,'.
                self::$main_table.'.payment_method_id ,
                payment_methods.name_'.$lang.' as payment_method_name ,
                branch_id ,
                finance_year_id ,
                receiving_palace ,
                transportation ,
                offer_due_term ,
                total_vat ,
                total_without_vat ,
                total_with_vat ,
                purchases_order_status ,
                purchases_order_active ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user
            ');
        }

        $data = $query->first();
        return $data;
    }

    public static function get_purchases_order_d($id, $lang = null)
    {
        $query = DB::table('purchases_order_d')
            ->leftjoin('warehouses' , 'purchases_order_d.warehouse_id' , '=' , 'warehouses.warehouse_id')
            ->leftjoin('items' , 'purchases_order_d.item_id' , '=' , 'items.item_id')
            ->leftjoin('unit_measurements' , 'purchases_order_d.unit_id' , '=' , 'unit_measurements.unit_measurement_id')
            ->leftjoin('taxes' , 'purchases_order_d.tax_percent_id' , '=' , 'taxes.tax_id')
            ->where('purchases_order_m_id', $id);

        if($lang != null){
            $query->selectRaw('
                purchases_order_m_id as m_id ,
                purchases_order_d_id as d_id ,
                purchases_order_d.warehouse_id ,
                warehouses.name_'.$lang.' as warehouse_name ,
                purchases_order_d.item_id ,
                items.name_'.$lang.' as item_name ,
                purchases_order_d.unit_id ,
                unit_measurements.name_'.$lang.' as unit_name ,
                quantity ,
                price ,
                total_price ,
                currency_id ,
                foreign_currency ,
                equivalent_value ,
                tax_percent_id ,
                taxes.tax_percentage as tax_percent ,
                total_vat ,
                total_without_vat ,
                total_with_vat ,
                purchases_order_d.received_quantity ,
                purchases_order_d.remaining_quantity
            ');
        }

        $data = $query->get();
        return $data;
    }

    public static function get_purchases_order_files($id)
    {
        return DB::table('purchases_order_files')
            ->where('purchases_order_m_id', $id)
            ->get();
    }

    public static function add_purchases_order_m($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function add_purchases_order_d($seed)
    {
        return DB::table('purchases_order_d')->insertGetId($seed);
    }

    public static function update_purchases_order_m($seed, $id)
    {
        return DB::table(self::$main_table)->where('purchases_order_m_id', $id)->update($seed);
    }

    public static function delete_purchases_order_m($id)
    {
        return DB::table(self::$main_table)->where('purchases_order_m_id', $id)->update(array('purchases_order_active' => '0', 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }

    public static function delete_purchases_order_d($id)
    {
        return DB::table('purchases_order_d')->where('purchases_order_m_id', $id)->delete();
    }
}
