<?php

namespace App\Models\Purchases;

use Illuminate\Database\Eloquent\Model;
use DB;

class PurchasesVendor extends Model
{
    protected $primaryKey     = 'purchases_vendor_id';
    public static $main_table = 'purchases_vendors';
    public $table             = 'purchases_vendors';

    public static $rules = array(
        'name_en'                  => 'required|string|unique:purchases_vendors' ,
        'name_ar'                  => 'required|string|unique:purchases_vendors' ,
        'address'                  => 'required|string' ,
        'purchases_vendor_type_id' => 'required|numeric' ,
        'grace_period'             => 'required|numeric' ,
        'credit_limit'             => 'required|numeric' ,
        'account_tree_id'          => 'required|numeric' ,
        'credit_date'              => 'required|date' ,
        'balance_nature'           => 'required|numeric' ,
        'currency_id'              => 'required|numeric' ,
    );

    public static function all_purchases_vendors($params = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('account_tree', self::$main_table.'.account_tree_id', '=', 'account_tree.account_tree_id')
            ->leftjoin('countrys', self::$main_table.'.country_id', '=', 'countrys.country_id')
            ->leftjoin('citys', self::$main_table.'.city_id', '=', 'citys.city_id')
            ->leftjoin('purchases_vendors_types', self::$main_table.'.purchases_vendor_type_id', '=', 'purchases_vendors_types.purchases_vendor_type_id')
            ->orderBy(self::$main_table.'.purchases_vendor_id', 'desc');

        if(isset($params['lang']))
            $query->selectRaw('
                purchases_vendor_id as id ,'.
                self::$main_table.'.name_'.$params['lang'].' as name ,'.
                self::$main_table.'.name_ar ,'.
                self::$main_table.'.name_en ,'.
                self::$main_table.'.address ,'.
                self::$main_table.'.purchases_vendor_type_id ,
                purchases_vendors_types.name_'.$params['lang'].' as purchases_vendor_type_name ,'.
                self::$main_table.'.grace_period ,'.
                self::$main_table.'.credit_limit ,'.
                self::$main_table.'.warning ,'.
                self::$main_table.'.country_id ,
                countrys.name_'.$params['lang'].' as country_name ,'.
                self::$main_table.'.city_id ,
                citys.name_'.$params['lang'].' as city_name ,'.
                self::$main_table.'.account_tree_id ,
                account_tree.name_'.$params['lang'].' as account_name ,'.
                self::$main_table.'.first_term_balance ,'.
                self::$main_table.'.credit_date ,'.
                self::$main_table.'.balance_nature ,'.
                self::$main_table.'.currency_id ,'.
                self::$main_table.'.is_taxable ,'.
                self::$main_table.'.tax_number ,'.
                self::$main_table.'.purchases_vendor_active,'.
                self::$main_table.'.add_date,'.
                self::$main_table.'.add_user
            ');

        if(isset($params['active']))
            $query->where('purchases_vendor_active', $params['active']);

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where(self::$main_table.'.name_en' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere(self::$main_table.'.name_ar' , 'LIKE' , "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_purchases_vendor($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('account_tree', self::$main_table.'.account_tree_id', '=', 'account_tree.account_tree_id')
            ->leftjoin('countrys', self::$main_table.'.country_id', '=', 'countrys.country_id')
            ->leftjoin('citys', self::$main_table.'.city_id', '=', 'citys.city_id')
            ->leftjoin('purchases_vendors_types', self::$main_table.'.purchases_vendor_type_id', '=', 'purchases_vendors_types.purchases_vendor_type_id')
            ->where('purchases_vendor_id', $id);

        $query->selectRaw('
            purchases_vendor_id as id ,'.
            self::$main_table.'.name_'.$lang.' as name ,'.
            self::$main_table.'.name_ar ,'.
            self::$main_table.'.name_en ,'.
            self::$main_table.'.tax_id ,'.
            self::$main_table.'.address ,'.
            self::$main_table.'.purchases_vendor_type_id ,
            purchases_vendors_types.name_'.$lang.' as purchases_vendor_type_name ,'.
            self::$main_table.'.grace_period ,'.
            self::$main_table.'.credit_limit ,'.
            self::$main_table.'.warning ,'.
            self::$main_table.'.country_id ,
            countrys.name_'.$lang.' as country_name ,'.
            self::$main_table.'.city_id ,
            citys.name_'.$lang.' as city_name ,'.
            self::$main_table.'.account_tree_id ,
            account_tree.name_'.$lang.' as account_name ,'.
            self::$main_table.'.first_term_balance ,'.
            self::$main_table.'.credit_date ,'.
            self::$main_table.'.balance_nature ,'.
            self::$main_table.'.currency_id ,'.
            self::$main_table.'.is_taxable ,'.
            self::$main_table.'.tax_number ,'.
            self::$main_table.'.purchases_vendor_active,'.
            self::$main_table.'.add_date,'.
            self::$main_table.'.add_user
        ');

        $data = $query->first();
        return $data;
    }

    public static function add_purchases_vendor($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_purchases_vendor($seed, $id)
    {
        return DB::table(self::$main_table)->where('purchases_vendor_id', $id)->update($seed);
    }

    public static function delete_purchases_vendor($id)
    {
        return DB::table(self::$main_table)->where('purchases_vendor_id', $id)->update(array('purchases_vendor_active' => 0, 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }
}
