<?php

namespace App\Models\Sales;

use Illuminate\Database\Eloquent\Model;
use DB;

class Quotation extends Model
{
    protected $primaryKey     = 'quotation_m_id';
    public static $main_table = 'quotation_m';
    public $table             = 'quotation_m';

    public static $master_rules = array(
        'quotation_date'        => 'required|date',
//        'quotation_description' => 'required',
        'customer_id'           => 'required|numeric',
        'sales_agent_id'        => 'required|numeric',
    );

    public static $details_rules = array(
        'item_id'        => 'required|numeric',
        'warehouse_id'   => 'required|numeric',
        'unit_id'        => 'required|numeric',
        'quantity'       => 'required|numeric',
        'price'          => 'required',
        'tax_percent_id' => 'required|numeric',
    );

    public static function all_quotations($params = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('customers' , self::$main_table.'.customer_id' , '=' , 'customers.customer_id')
            ->leftjoin('sales_agents' , self::$main_table.'.sales_agent_id' , '=' , 'sales_agents.sales_agent_id')
            ->orderBy(self::$main_table.'.quotation_m_id', 'desc');

        if($params['lang'] != null){
            $query->selectRaw('
                quotation_m_id as m_id ,
                quotation_date ,
                quotation_description ,'.
                self::$main_table.'.customer_id ,
                customers.name_'.$params['lang'].' as customer_name ,'.
                self::$main_table.'.sales_agent_id ,
                sales_agents.name_'.$params['lang'].' as sales_agent_name ,
                branch_id ,
                finance_year_id ,
                invoice_discount ,
                if(invoice_discount = "1", true, false ) as has_discount ,
                discount_type ,
                validity,
                term_payment,
                discount ,
                quotation_status ,
                quotation_active ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user ,
                total_vat ,
                total_without_vat ,
                total_with_vat ,
                total_discount ,
                total_price_after_discount
            ');
        }

        if(isset($params['active']))
            $query->where('quotation_active', $params['active']);

        if(isset($params['status']))
            $query->where('quotation_status', $params['status']);

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where('quotation_description', 'LIKE', "%{$params['word']}%")
                    ->orWhere('customers.name_ar', 'LIKE', "%{$params['word']}%")
                    ->orWhere('customers.name_en', 'LIKE', "%{$params['word']}%")
                    ->orWhere('sales_agents.name_ar', 'LIKE', "%{$params['word']}%")
                    ->orWhere('sales_agents.name_en', 'LIKE', "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_quotation_m($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->leftjoin('customers' , self::$main_table.'.customer_id' , '=' , 'customers.customer_id')
            ->leftjoin('sales_agents' , self::$main_table.'.sales_agent_id' , '=' , 'sales_agents.sales_agent_id')
            ->where('quotation_m_id' , $id);

        if($lang != null){
            $query->selectRaw('
                quotation_m_id as m_id ,
                quotation_date ,
                quotation_description ,'.
                self::$main_table.'.customer_id ,
                customers.name_'.$lang.' as customer_name ,'.
                self::$main_table.'.sales_agent_id ,
                sales_agents.name_'.$lang.' as sales_agent_name ,
                branch_id ,
                finance_year_id ,
                invoice_discount ,
                validity,
                term_payment,
                if(invoice_discount = "1", true, false ) as has_discount ,
                discount_type ,
                discount ,
                extra_inputs ,
                quotation_status ,
                quotation_active ,'.
                self::$main_table.'.add_date ,'.
                self::$main_table.'.add_user ,
                total_vat ,
                total_without_vat ,
                total_with_vat ,
                total_discount ,
                total_price_after_discount , 
                currency_id
            ');
        }

        $data = $query->first();
        return $data;
    }

    public static function get_quotation_d($id, $lang = null)
    {
        $query = DB::table('quotation_d')
            ->leftjoin('items' , 'quotation_d.item_id' , '=' , 'items.item_id')
            ->leftjoin('warehouses' , 'quotation_d.warehouse_id' , '=' , 'warehouses.warehouse_id')
            ->leftjoin('unit_measurements' , 'quotation_d.unit_id' , '=' , 'unit_measurements.unit_measurement_id')
            ->leftjoin('taxes' , 'quotation_d.tax_percent_id' , '=' , 'taxes.tax_id')
            ->where('quotation_m_id', $id);

        if($lang != null){
            $query->selectRaw('
                quotation_m_id as m_id ,
                quotation_d_id as d_id ,
                quotation_d.item_id ,
                items.name_'.$lang.' as item_name ,
                items.image as item_image ,
                items.price_include_vat as price_include_vat ,
                items.item_width_height ,
                quotation_d.warehouse_id ,
                warehouses.name_'.$lang.' as warehouse_name ,
                quotation_d.unit_id ,
                unit_measurements.name_'.$lang.' as unit_name ,
                extra_inputs ,

                width ,
                height ,

                area_width ,
                area_height ,
                area_quantity ,
                quotation_d.description ,
                quantity ,

                quotation_d.price ,
                quotation_d.item_price ,
                quotation_d.total_price ,
                quotation_d.currency_id ,
                quotation_d.foreign_currency ,
                quotation_d.equivalent_value ,


                quotation_d.item_discount ,
                quotation_d.total_discount ,

                discount ,
                discount_per ,
                tax_percent_id ,
                taxes.tax_percentage as tax_percent ,
                total_vat ,
                total_without_vat ,
                total_with_vat
            ');
        }

        $data = $query->get();
        return $data;
    }

    public static function add_quotation_m($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function add_quotation_d($seed)
    {
        return DB::table('quotation_d')->insertGetId($seed);
    }

    public static function update_quotation_m($seed, $id)
    {
        return DB::table(self::$main_table)->where('quotation_m_id', $id)->update($seed);
    }

    public static function delete_quotation_m($id)
    {
        return DB::table(self::$main_table)->where('quotation_m_id', $id)->update(array('quotation_active' => '0', 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }

    public static function delete_quotation_d($id)
    {
        return DB::table('quotation_d')->where('quotation_m_id', $id)->delete();
    }
}
