<?php

namespace App\Models\Sales;

use Illuminate\Database\Eloquent\Model;
use DB;

class SalesArea extends Model
{
    protected $primaryKey     = 'sales_area_id';
    public static $main_table = 'sales_areas';
    public $table             = 'sales_areas';

    public static $rules = array(
        'name_en'  => 'required|string|unique:sales_areas' ,
        'name_ar'  => 'required|string|unique:sales_areas' ,
    );

    public static function all_sales_areas($params = null)
    {
        $query = DB::table(self::$main_table)
            ->orderBy(self::$main_table.'.sales_area_id', 'desc');

        if(isset($params['lang']))
            $query->selectRaw('
                sales_area_id as id ,'.
                self::$main_table.'.name_'.$params['lang'].' as name ,'.
                self::$main_table.'.name_ar ,'.
                self::$main_table.'.name_en ,'.
                self::$main_table.'.location ,'.
                self::$main_table.'.sales_area_status,'.
                self::$main_table.'.sales_area_active,'.
                self::$main_table.'.add_date,'.
                self::$main_table.'.add_user
            ');

        if(isset($params['active']))
            $query->where('sales_area_active', $params['active']);

        if(isset($params['word']) && strlen($params['word']) > 0){
            $query->where(function ($stmt) use($params) {
                $stmt->where('name_en' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere('name_ar' , 'LIKE' , "%{$params['word']}%")
                    ->orWhere('location' , 'LIKE' , "%{$params['word']}%");
            });
        }

        if(isset($params['rows'])){
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        }else{
            $data = $query->get();
        }

        return $data;
    }

    public static function get_sales_area($id, $lang = null)
    {
        $query = DB::table(self::$main_table)
            ->where('sales_area_id', $id);

        $query->selectRaw('
            sales_area_id as id ,'.
            self::$main_table.'.name_'.$lang.' as name ,'.
            self::$main_table.'.name_ar ,'.
            self::$main_table.'.name_en ,'.
            self::$main_table.'.location ,'.
            self::$main_table.'.sales_area_status,'.
            self::$main_table.'.sales_area_active,'.
            self::$main_table.'.add_date,'.
            self::$main_table.'.add_user
        ');

        $data = $query->first();
        return $data;
    }

    public static function add_sales_area($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }

    public static function update_sales_area($seed, $id)
    {
        return DB::table(self::$main_table)->where('sales_area_id', $id)->update($seed);
    }

    public static function delete_sales_area($id)
    {
        return DB::table(self::$main_table)->where('sales_area_id', $id)->update(array('sales_area_active' => 0, 'disable_date' => date("Y-m-d H:i:s"), 'disable_user' => auth()->user()->id));
    }
}
