<?php

namespace App\Models;

use Illuminate\Notifications\Notifiable;
use Illuminate\Contracts\Auth\MustVerifyEmail;
use Illuminate\Foundation\Auth\User as Authenticatable;

use DB;

class User extends Authenticatable
{
    use Notifiable;

    /**
     * The attributes that are mass assignable.
     *
     * @var array
     */
    protected $fillable = [
        'name',
        'email',
        'password',
    ];

    /**
     * The attributes that should be hidden for arrays.
     *
     * @var array
     */
    protected $hidden = [
        'password',
        'remember_token',
        'api_token',
    ];

    /**
     * The attributes that should be cast to native types.
     *
     * @var array
     */
    protected $casts = [
        'email_verified_at' => 'datetime',
    ];

    public static $rules = array(
        'username'      => 'required|string|min:1|unique:users',
        'email'         => 'required|email|unique:users',
        'mobile'        => 'required|numeric|unique:users',
        'user_full_name' => 'required|string|min:1',
        'password'      => 'required|min:1',
        'title_id'      => 'required|numeric',
        'user_titles' => 'sometimes|required',
    );
    

    public static function attributeLabels()
    {
        return [
            'username'    => __('main.username'),
            'email'       => __('main.email'),
            'mobile'      => __('main.mobile'),
            'user_full_name' => __('main.user_full_name'),
            'password'    => __('main.password'),
            'title_id'    => __('main.title_id'),
            'user_titles' => __('main.user_titles'),
        ];
    }


    public static $main_table = 'users';


    public static function all_users($params = null)
    {
        $query =  DB::table(self::$main_table)
            ->leftjoin('title', self::$main_table . '.title_id', '=', 'title.title_id');

        if (isset($params['lang'])) {
            $query->selectRaw('id , ' . self::$main_table . '.title_id as title_id , title_name_' . $params['lang'] . ' as title , username , mobile , email , user_full_name , sales_agent_id  , default_lang , default_branch , default_year  , image_url ,barber_id, pos , view_all_data');
        } else {
            $query->selectRaw('id , ' . self::$main_table . '.title_id , username , mobile , email , user_full_name , sales_agent_id  , default_lang , default_branch , default_year , barber_id , image_url,view_all_data');
        }

        if (isset($params['word']) && strlen($params['word']) >  0) {
            $query->where(function ($stmt) use ($params) {
                $stmt->where(self::$main_table . '.id', $params['word'])
                    ->orWhere(self::$main_table . '.username', 'like', '%' . $params['word'] . '%')
                    ->orWhere(self::$main_table . '.user_full_name', 'like', '%' . $params['word'] . '%')
                    ->orWhere(self::$main_table . '.mobile', 'like', '%' . $params['word'] . '%')
                    ->orWhere(self::$main_table . '.email', 'like', '%' . $params['word'] . '%');
            });
        } elseif (isset($params['word']) && is_array($params['word'])) {
            $query->where(function ($stmt) use ($params) {
                $stmt->whereIn(self::$main_table . '.id',  $params['user']);
            });
        }

        if (isset($params['user_active'])) {
            $query->where(self::$main_table . '.user_active',  $params['user_active']);
        }

        if (isset($params['active'])) {
            $query->where(self::$main_table . '.user_active',  $params['active']);
        }

        if (isset($params['rows'])) {
            $data = $query->paginate($params['rows'], ['*'], 'page', $params['page'] ?? 1);
        } else {
            $data = $query->get();
        }

        return $data;
    }

    public static function get_user($id, $lang = null)
    {
        $query =  DB::table(self::$main_table)
            ->join('title', self::$main_table . '.title_id', '=', 'title.title_id')
            ->where('id', $id);

        if (isset($lang)) {

            $query->selectRaw('id , ' . self::$main_table . '.title_id as title_id , title_name_' . $lang . ' as title , username , mobile , email , user_full_name , sales_agent_id  , default_lang , default_branch , default_year  , api_token , image_url , barber_id , pos , super_admin  ,is_nfc,view_all_data');
        } else {
            $query->selectRaw('id , ' . self::$main_table . '.title_id , username , mobile , email , user_full_name , sales_agent_id  , default_lang , default_branch , default_year , api_token , image_url , pos , barber_id , super_admin , is_nfc ,view_all_data');
        }

        $data = $query->first();
        return $data;
    }

    public static function get_user_permission($id,  $lang = null, $codes = null, $type = null, $title = null)
    {
        $query = DB::table('user_permissions')
            ->join('screen_subs', 'user_permissions.screen_sub_id', '=', 'screen_subs.screen_sub_id')
            ->join('screen_cats', 'screen_subs.screen_cat_id', '=', 'screen_cats.screen_cat_id')
            ->join('screen_mains', 'screen_cats.screen_main_id', '=', 'screen_mains.screen_main_id')
            ->orderBy('screen_mains.screen_main_order')
            ->orderBy('screen_cats.screen_cat_order')
            ->orderBy('screen_sub_order')
            ->where('screen_sub_active', 1)
            ->where('user_permissions.permission', "<>", "[]")
            ->where('user_id', $id);

        //        if ($title != null) {
        //            $query->where('title_id', $title);
        //        }

        if ($title != null) {
            $query->where(function ($stmt) use ($title) {
                $stmt->where('title_id', $title)
                    ->orWhereNull('title_id');
            });
        }

        if ($lang != null) {
            $query->selectRaw('
                screen_code ,
                permission ,
                url ,
                actions ,
                user_permissions.title_id,
                screen_cats.screen_cat_id as cat_id ,
                screen_cat_title_' . $lang . ' as cat_title ,
                screen_subs.screen_sub_id as sub_id ,
                screen_sub_title_' . $lang . ' as sub_title ,
                screen_mains.screen_main_id as main_id ,
                screen_main_title_' . $lang . ' as main_title ,
                screen_main_image as main_image
            ');
        } elseif ($codes != null) {
            $query->selectRaw('screen_subs.screen_sub_id as id , screen_code , permission');
        }

        if ($type != null) {
            $query->whereRaw('FIND_IN_SET(' . $type . ' ,  stock_type )');
        }

        $data = $query->get();
        return $data;
    }

    public static function clear_permission($id)
    {
        DB::table('user_permissions')
            ->where('user_id', $id)
            ->delete();
    }

    public static function insert_user_permission($seed)
    {
        return DB::table('user_permissions')->insert($seed);
    }
    public static function add_user($seed)
    {
        return DB::table(self::$main_table)->insertGetId($seed);
    }


    public static function update_user($seed,  $id)
    {
        return DB::table(self::$main_table)->where('id', $id)->update($seed);
    }

    public static function delete_user($id)
    {
        return DB::table(self::$main_table)->where('id', $id)->update(array('user_active' => '0'));
    }
}
