<?php

use Illuminate\Support\Facades\Route;

Route::group(['prefix'=>'website/{lang}' ,'middleware' => ['VerifyAPIWebsiteAccess'] , 'where' => ['lang' => 'en|ar']  , "namespace"=>"App\Http\Controllers\API\Website"  ], function(){

        // Frontend

        Route::post('/login_mobile',"Frontend\AuthController@login_mobile");
        Route::post('/login_otp',"Frontend\AuthController@login_otp");
        Route::post('/login_social',"Frontend\AuthController@login_social");

        Route::get('/get_home', "Frontend\HomePageController@get_home_data");
        Route::get('/get_coupon_data/{coupon_code}', "Frontend\Booking\BookingController@get_coupon_data");
        Route::post('/get_available_times', "Frontend\Booking\BookingController@get_available_times");
        Route::post('/get_available_dates', "Frontend\Booking\BookingController@get_available_dates");
        Route::get('/create_booking', "Frontend\Booking\BookingController@create_booking");

        Route::group(['middleware' => 'auth:customer'], function (){
            Route::get('/get_my_profile', "Frontend\GeneralController@get_my_profile");
            Route::post('/update_profile', "Frontend\GeneralController@update_profile");
            Route::post('/make_booking', "Frontend\Booking\BookingController@make_booking");
            Route::post('/update_booking/{id}', "Frontend\Booking\BookingController@update_booking");
            Route::post('/reject_booking/{id}', "Frontend\Booking\BookingController@reject_booking");
            Route::get('/get_my_bookings', "Frontend\Booking\BookingController@get_my_bookings");
            Route::get('/get_booking_details/{id}', "Frontend\Booking\BookingController@get_booking_details");
        });
});
?>
